/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.group;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowGroup;
import org.chorem.bow.BowGroupImpl;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;

public class GroupEditAction
extends BowBaseAction {
    private static final Log log = LogFactory.getLog(GroupEditAction.class);
    private static final long serialVersionUID = 1L;
    protected String groupId;
    protected BowGroup group;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public BowGroup getGroup() {
        if (this.group == null) {
            this.loadGroup();
        }
        return this.group;
    }

    public boolean isPublic() {
        return BowUtils.isPublicGroup((BowGroup)this.getGroup());
    }

    /*
     * Unable to fully structure code
     */
    public void setPublic(boolean pub) {
        if (!pub) ** GOTO lbl-1000
        this.getConfig();
        if (BowConfig.isAllowPublicGroup()) {
            reader = "all";
        } else lbl-1000:
        // 2 sources

        {
            reader = this.getGroup().getWikittyId();
        }
        this.getGroup().setReader(Collections.singleton(reader));
    }

    public void loadGroup() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("group load " + this.group));
        }
        BowProxy proxy = this.getBowProxy();
        if (StringUtils.isBlank((CharSequence)this.groupId)) {
            BowSession session = this.getBowSession();
            BowUser user = session.getUser();
            this.group = new BowGroupImpl();
            this.group.addMembers(new Wikitty[]{(Wikitty)proxy.castTo(Wikitty.class, (Object)user)});
            this.setPublic(false);
        } else {
            this.group = (BowGroup)proxy.restore(BowGroup.class, this.groupId, new String[]{"WikittyGroup.members"});
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("group loaded " + this.group));
        }
    }

    public String load() throws Exception {
        return "success";
    }

    public String removeMe() throws Exception {
        String result = "success";
        try {
            String groupName = this.getGroup().getName();
            BowUser user = this.getBowUser();
            BowProxy proxy = this.getBowProxy();
            this.getGroup().removeMembers(new String[]{user.getWikittyId()});
            if (CollectionUtils.isEmpty((Collection)this.getGroup().getMembers())) {
                this.addActionMessage(this.t("bow.group.delete.no.member", new Object[0]));
                proxy.delete((BusinessEntity)this.group);
            } else {
                proxy.store((BusinessEntity)this.group);
            }
            this.getBowSession().removeAndAddTag(Collections.singletonList("@" + groupName), Collections.singletonList(groupName));
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }

    public String save() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("group save " + this.group));
        }
        String result = "success";
        try {
            BowSession session = this.getBowSession();
            BowProxy proxy = session.getProxy();
            String groupName = this.group.getName();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                HashMap<String, String> logins = new HashMap<String, String>();
                for (String login : this.getGroup().getMembers()) {
                    if (!StringUtils.startsWith((CharSequence)login, (CharSequence)"add ")) continue;
                    logins.put(StringUtils.substringAfter((String)login, (String)"add "), login);
                }
                if (!logins.isEmpty()) {
                    WikittyQuery criteria = ((WikittyQueryMaker)new WikittyQueryMaker().containsOne((Element)BowUser.ELEMENT_FIELD_WIKITTYUSER_LOGIN, logins.keySet())).end();
                    WikittyQueryResult users = proxy.findAllByQuery(Wikitty.class, criteria);
                    this.getGroup().removeMembers(logins.values().toArray(new String[logins.size()]));
                    this.getGroup().addMembers(users.getAll().toArray(new Wikitty[users.size()]));
                    if (users.size() != logins.size()) {
                        for (Wikitty w : users) {
                            logins.remove(WikittyUserHelper.getLogin((Wikitty)w));
                        }
                        this.addActionError(this.t("bow.group.some.user.not.found", new Object[]{StringUtils.join(logins.keySet(), (String)", ")}));
                        result = "error";
                    }
                }
                if (result == "success" && CollectionUtils.isEmpty((Collection)this.getGroup().getMembers())) {
                    this.addActionMessage(this.t("bow.group.delete.no.member", new Object[0]));
                    proxy.delete((BusinessEntity)this.group);
                    this.getBowSession().removeAndAddTag(Collections.singletonList("@" + groupName), Collections.singletonList(groupName));
                } else {
                    this.getGroup().setAdmin(Collections.singleton(this.getGroup().getWikittyId()));
                    proxy.store((BusinessEntity)this.group);
                }
            } else {
                this.addActionError(this.t("bow.group.name.blank", new Object[0]));
                result = "error";
            }
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }

    public String delete() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("group delete " + this.group));
        }
        String result = "success";
        try {
            String groupName = this.getGroup().getName();
            BowProxy proxy = this.getBowProxy();
            proxy.delete((BusinessEntity)this.group);
            this.getBowSession().removeAndAddTag(Collections.singletonList("@" + groupName), Collections.singletonList(groupName));
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }
}

