/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.bookmark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowAuthentication;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

public class DeleteSearchResultsAction
extends BowBaseAction {
    private static final long serialVersionUID = -3903724044644625507L;
    private static final Log log = LogFactory.getLog(DeleteSearchResultsAction.class);

    public String execute() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.tagLine) || StringUtils.isNotBlank((CharSequence)this.fullTextLine)) {
                BowUser user = this.getBowSession().getUser();
                WikittyQuery criteria = BookmarkUtils.getBookmarkListCriteriaByUser((BowUser)user, (List)this.listId, (String)this.tagLine, (String)this.fullTextLine, (boolean)false, null, (int)0);
                criteria.setLimit(Integer.MAX_VALUE);
                BowProxy proxy = this.getBowProxy();
                List ids = proxy.findAllByQuery(criteria).getAll();
                criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("BowAuthentication")).containsOne((Element)BowAuthentication.ELEMENT_FIELD_BOWAUTHENTICATION_TARGET, (Collection)ids)).end();
                List authIds = proxy.findAllByQuery(criteria).getAll();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Will delete %s bookmarks and %s authentications", ids.size(), authIds.size()));
                }
                ArrayList all = new ArrayList(ids.size() + authIds.size());
                all.addAll(ids);
                all.addAll(authIds);
                proxy.delete(all);
                this.addActionMessage(this.t("bow.search.results.deleted", new Object[]{ids.size()}));
            }
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
        }
        return "success";
    }
}

