/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.bookmark;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowAuthentication;
import org.chorem.bow.BowProxy;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.BusinessEntity;

public class AuthenticationEditAction
extends BowBaseAction {
    private static final Log log = LogFactory.getLog(AuthenticationEditAction.class);
    private static final long serialVersionUID = 1L;
    protected String bookmarkId;
    protected BowAuthentication authentication;

    public String getBookmarkId() {
        return this.bookmarkId;
    }

    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    public boolean isShareSecurity() {
        BowAuthentication auth = this.getAuthentication();
        boolean result = !CollectionUtils.isEmpty((Collection)auth.getParent());
        return result;
    }

    public void setShareSecurity(boolean shareSecurity) {
        if (shareSecurity) {
            this.getAuthentication().setParent(Collections.singleton(this.bookmarkId));
        } else {
            this.getAuthentication().clearParent();
        }
    }

    public BowAuthentication getAuthentication() {
        if (this.authentication == null) {
            this.authentication = this.getBowSession().getAuthentication(this.bookmarkId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("authentication loaded " + this.authentication));
            }
        }
        return this.authentication;
    }

    public String load() throws Exception {
        return "success";
    }

    public String save() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("authentication save " + this.authentication));
        }
        String result = "success";
        try {
            BowProxy proxy = this.getBowProxy();
            proxy.store((BusinessEntity)this.authentication);
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }

    public String delete() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("authentication delete " + this.authentication));
        }
        String result = "success";
        try {
            BowProxy proxy = this.getBowProxy();
            proxy.delete((BusinessEntity)this.authentication);
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }
}

