/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.bookmark;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowBookmarkImpl;
import org.chorem.bow.BowGroup;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSharedUser;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;

public class AddOrUpdateAction
extends BowBaseAction {
    private static final long serialVersionUID = 3389170166034184139L;
    private static Log log = LogFactory.getLog(AddOrUpdateAction.class);
    protected String bookmarkId;
    protected String link;
    protected String name;
    protected String privateAlias;
    protected String publicAlias;
    protected String tags;
    protected String nameAndTags;
    protected String redirectTo;
    protected boolean forceEdit;
    protected boolean redirectLink;

    public String getBookmarkId() {
        return this.bookmarkId;
    }

    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrivateAlias() {
        return this.privateAlias;
    }

    public void setPrivateAlias(String privateAlias) {
        this.privateAlias = privateAlias;
    }

    public String getPublicAlias() {
        return this.publicAlias;
    }

    public void setPublicAlias(String publicAlias) {
        this.publicAlias = publicAlias;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getNameAndTags() {
        return this.nameAndTags;
    }

    public void setNameAndTags(String nameAndTags) {
        this.nameAndTags = nameAndTags;
    }

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public boolean isForceEdit() {
        return this.forceEdit;
    }

    public void setForceEdit(boolean forceEdit) {
        this.forceEdit = forceEdit;
    }

    public boolean isRedirectLink() {
        return this.redirectLink;
    }

    public void setRedirectLink(boolean redirectLink) {
        this.redirectLink = redirectLink;
    }

    public String execute() {
        String result = "success";
        try {
            WikittyQueryResult aliasResult;
            boolean isScriptlet = false;
            BowProxy proxy = this.getBowProxy();
            BowBookmark bookmark = null;
            if (StringUtils.isBlank((CharSequence)this.link)) {
                if (StringUtils.contains((CharSequence)this.nameAndTags, (CharSequence)"|")) {
                    this.link = StringUtils.substringAfterLast((String)this.nameAndTags, (String)"|");
                    this.nameAndTags = StringUtils.substringBeforeLast((String)this.nameAndTags, (String)"|");
                } else {
                    this.link = this.nameAndTags;
                    this.nameAndTags = "";
                }
            }
            if (this.name == null) {
                isScriptlet = true;
                this.nameAndTags = StringUtils.trimToEmpty((String)this.nameAndTags);
                this.name = StringUtils.substringBeforeLast((String)this.nameAndTags, (String)"|");
                this.tags = StringUtils.substringAfterLast((String)this.nameAndTags, (String)"|");
            }
            this.name = BowUtils.normalizeString((String)this.name);
            this.link = BowUtils.normalizeUrl((String)this.link);
            this.tags = BowUtils.normalizeString((String)this.tags);
            this.privateAlias = BowUtils.normalizeString((String)this.privateAlias);
            this.publicAlias = BowUtils.normalizeString((String)this.publicAlias);
            BowUser user = this.getBowSession().getUser();
            String userId = user.getWikittyId();
            if (StringUtils.isNotBlank((CharSequence)this.bookmarkId)) {
                bookmark = (BowBookmark)proxy.restore(BowBookmark.class, this.bookmarkId, new String[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Change old wikitty: " + bookmark));
                }
            } else {
                WikittyQuery criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).eq("BowBookmark.link", (Object)this.link)).eq("WikittyAuthorisation.owner", (Object)userId)).end();
                bookmark = (BowBookmark)proxy.findByQuery(BowBookmark.class, criteria);
                if (bookmark != null) {
                    String description = bookmark.getDescription();
                    this.name = description + "\n" + BowUtils.formatDate((Date)new Date()) + ": " + this.name;
                    this.tags = this.tags + " " + BookmarkUtils.getBookmarkTagsString((BowBookmark)bookmark);
                }
            }
            if (bookmark == null) {
                bookmark = new BowBookmarkImpl();
                bookmark.setClick(0);
                bookmark.setOwner((WikittyUser)user);
                bookmark.addReader(new String[]{user.getWikittyId()});
                bookmark.setCreationDate(new Date());
                if (user.getScreenshot().booleanValue()) {
                    byte[] screenshot = BookmarkUtils.getScreenshot((String)this.link);
                    bookmark.setScreenshot(screenshot);
                }
                if (user.getFavicon().booleanValue()) {
                    byte[] favicone = BookmarkUtils.getFavicon((String)this.link);
                    bookmark.setFavicon(favicone);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Change old bookmark: " + bookmark));
            }
            bookmark.setDescription(this.name);
            bookmark.setLink(this.link);
            Set tagsWord = BowUtils.getWords((String)this.tags);
            bookmark.setLabels(tagsWord);
            HashSet authParent = new HashSet();
            Set groupsName = BowUtils.getGroups((Set)tagsWord);
            if (CollectionUtils.isNotEmpty((Collection)groupsName)) {
                WikittyQuery groupsQuery = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).containsOne((Element)BowGroup.ELEMENT_FIELD_WIKITTYGROUP_NAME, (Collection)groupsName)).eq((Element)BowGroup.ELEMENT_FIELD_WIKITTYGROUP_MEMBERS, (Object)userId)).end();
                WikittyQueryResult groupsId = proxy.findAllByQuery(groupsQuery);
                authParent.addAll(groupsId.getAll());
                if (groupsName.size() != groupsId.size()) {
                    List groups = proxy.restore(BowGroup.class, groupsId.getAll(), new String[0]);
                    for (BowGroup g : groups) {
                        groupsName.remove(g.getName());
                    }
                    for (String groupName : groupsName) {
                        bookmark.removeLabels(new String[]{"@" + groupName});
                    }
                    this.addActionMessage(this.t("bow.group.not.members", new Object[]{StringUtils.join((Iterable)groupsName, (String)", ")}));
                }
            }
            bookmark.setParent(authParent);
            HashSet authReader = new HashSet();
            Set usersLogin = BowUtils.getUsers((Set)tagsWord);
            if (CollectionUtils.isNotEmpty((Collection)usersLogin)) {
                WikittyQuery sharedUsersQuery = ((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).containsOne((Element)BowUser.ELEMENT_FIELD_WIKITTYUSER_LOGIN, (Collection)usersLogin)).end();
                WikittyQueryResult sharedUsersId = proxy.findAllByQuery(sharedUsersQuery);
                authReader.addAll(sharedUsersId.getAll());
                if (usersLogin.size() != sharedUsersId.size()) {
                    List sharedUsers = proxy.restore(BowSharedUser.class, sharedUsersId.getAll(), new String[0]);
                    for (BowSharedUser g : sharedUsers) {
                        usersLogin.remove(g.getLogin());
                    }
                    for (String sharedUserName : usersLogin) {
                        bookmark.removeLabels(new String[]{"#" + sharedUserName});
                    }
                    this.addActionMessage(this.t("bow.user.not.found", new Object[]{StringUtils.join((Iterable)usersLogin, (String)", ")}));
                }
            }
            bookmark.setReader(authReader);
            if (StringUtils.isBlank((CharSequence)this.privateAlias)) {
                bookmark.setPrivateAlias("");
            } else {
                WikittyQuery privateAliasCriteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).eq("BowBookmark.privateAlias", (Object)this.privateAlias)).eq("WikittyAuthorisation.owner", (Object)userId)).end().setLimit(1);
                aliasResult = proxy.findAllByQuery(privateAliasCriteria);
                if (aliasResult.getTotalResult() == 0 || bookmark.getWikittyId().equals(aliasResult.get(0))) {
                    bookmark.setPrivateAlias(this.privateAlias);
                } else {
                    this.addActionMessage(this.t("bow.alias.already.exists", new Object[]{this.privateAlias}));
                }
            }
            if (StringUtils.isBlank((CharSequence)this.publicAlias)) {
                bookmark.setPublicAlias("");
            } else {
                WikittyQuery publicAliasCriteria = ((WikittyQueryMaker)new WikittyQueryMaker().eq("BowBookmark.publicAlias", (Object)this.publicAlias)).end().setLimit(1);
                aliasResult = proxy.findAllByQuery(publicAliasCriteria);
                if (aliasResult.getTotalResult() == 0 || bookmark.getWikittyId().equals(aliasResult.get(0))) {
                    bookmark.setPublicAlias(this.publicAlias);
                } else {
                    this.addActionMessage(this.t("bow.alias.already.exists", new Object[]{this.publicAlias}));
                }
            }
            proxy.store((BusinessEntity)bookmark);
            this.addActionMessage(this.t("bow.bookmark.add.successful", new Object[0]));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding URL");
            }
            if (this.forceEdit || isScriptlet && (StringUtils.isBlank((CharSequence)bookmark.getDescription()) || CollectionUtils.isEmpty((Collection)bookmark.getLabels()))) {
                this.redirectTo = String.format("editBookmark.action?redirectLink=%s&id=%s", this.redirectLink, bookmark.getWikittyId());
            } else if (this.redirectLink) {
                this.redirectTo = bookmark.getLink();
            } else if (StringUtils.isEmpty((CharSequence)this.tagLine) && StringUtils.isEmpty((CharSequence)this.fullTextLine)) {
                this.listId = Collections.singletonList(bookmark.getWikittyId());
                this.redirectTo = BowUtils.redirectTo((List)this.listId, (String)this.tagLine, (String)this.fullTextLine);
            } else {
                this.redirectTo = BowUtils.redirectTo((String)this.tagLine, (String)this.fullTextLine);
            }
        }
        catch (Exception eee) {
            result = "error";
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
        }
        return result;
    }
}

