/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

public class AliasAction
extends BowBaseAction {
    private static final Log log = LogFactory.getLog(AliasAction.class);
    private static final long serialVersionUID = 1L;
    protected String redirectTo = "/";
    protected String alias;
    protected String bookmarkId;

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    public String execute() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirect alias " + this.alias));
        }
        String result = "success";
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.alias)) {
                BowUser user;
                WikittyQuery criteria;
                BowProxy proxy = this.getBowProxy();
                String link = proxy.findByQuery(criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().select((Element)BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_LINK)).where()).or()).eq("BowBookmark.publicAlias", (Object)this.alias)).end());
                if (link == null && (user = this.getBowSession().getUser()) != null) {
                    criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("BowBookmark")).eq("WikittyAuthorisation.owner", (Object)user.getWikittyId())).or()).ideq((Object)this.alias)).eq("BowBookmark.privateAlias", (Object)this.alias)).end();
                    BowBookmark bookmark = (BowBookmark)proxy.findByQuery(BowBookmark.class, criteria);
                    if (bookmark == null) {
                        WikittyQueryMaker query = (WikittyQueryMaker)new WikittyQueryMaker().and();
                        BookmarkUtils.addEqUser((WikittyQueryMaker)query, (String)user.getWikittyId());
                        criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)query.exteq("BowBookmark")).or()).ideq((Object)this.alias)).eq("BowBookmark.privateAlias", (Object)this.alias)).end();
                        bookmark = (BowBookmark)proxy.findByQuery(BowBookmark.class, criteria);
                    }
                    if (bookmark != null) {
                        link = bookmark.getLink();
                        int clicks = bookmark.getClick() + 1;
                        bookmark.setClick(clicks);
                        proxy.store((BusinessEntity)bookmark);
                    }
                }
                if (link != null) {
                    this.redirectTo = link;
                } else {
                    log.error((Object)String.format("No bookmark with alias or id '%s'", this.alias));
                    this.addActionError(this.t("bow.alias.bookmarkId.unknown", new Object[]{this.alias}));
                    result = "error";
                }
            }
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }

    public String create() throws Exception {
        String result = "success";
        try {
            if (!StringUtils.isEmpty((CharSequence)this.alias)) {
                WikittyQuery criteria;
                BowProxy proxy = this.getBowProxy();
                BowBookmark bookmark = (BowBookmark)proxy.findByQuery(BowBookmark.class, criteria = ((WikittyQueryMaker)new WikittyQueryMaker().eq("BowBookmark.publicAlias", (Object)this.alias)).end());
                if (bookmark != null) {
                    this.addActionError(this.t("bow.alias.already.exists", new Object[]{this.alias}));
                    log.error((Object)("A bookmark already exists with alias " + this.alias));
                    result = "error";
                } else {
                    bookmark = (BowBookmark)proxy.restore(BowBookmark.class, this.bookmarkId, new String[0]);
                    if (bookmark != null) {
                        bookmark.setPublicAlias(this.alias);
                        proxy.store((BusinessEntity)bookmark);
                    } else {
                        this.addActionError(this.t("bow.alias.bookmarkId.unknown", new Object[]{this.bookmarkId}));
                        log.debug((Object)("No bookmark with id " + this.bookmarkId));
                        result = "error";
                    }
                }
            }
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }

    public String delete() throws Exception {
        log.debug((Object)("delete alias for id " + this.bookmarkId));
        String result = "success";
        try {
            BowProxy proxy = this.getBowProxy();
            BowBookmark bookmark = (BowBookmark)proxy.restore(BowBookmark.class, this.bookmarkId, new String[0]);
            if (bookmark != null) {
                bookmark.setPublicAlias(null);
                proxy.store((BusinessEntity)bookmark);
            } else {
                this.addActionError(this.t("bow.alias.bookmarkId.unknown", new Object[]{this.bookmarkId}));
                log.error((Object)("No bookmark with id " + this.bookmarkId));
                result = "error";
            }
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }
}

