/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowAuthentication;
import org.chorem.bow.BowGroup;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

/*
 * Exception performing whole class analysis ignored.
 */
public class BowUtils {
    private static final Log log = LogFactory.getLog(BowUtils.class);
    public static final String BOW_DATE_SHORT_PATTERN = "yyyy/MM/dd";
    private static final Configuration markdownConf = Configuration.builder().forceExtentedProfile().enableSafeMode().build();
    public static Map<String, String> resourceContent = new HashMap();

    public static String toHtml(String markdown) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)markdown)) {
            result = Processor.process((String)markdown, (Configuration)markdownConf);
        }
        return result;
    }

    public static String getResourceContent(String resourceName) throws IOException {
        String result = (String)resourceContent.get(resourceName);
        if (result == null) {
            URL resource = BowUtils.class.getResource("/" + resourceName);
            result = IOUtils.toString((URL)resource);
            resourceContent.put(resourceName, result);
        }
        return result;
    }

    public static String scriptletPassword(BowAuthentication auth) {
        String result = "";
        try {
            String js = BowUtils.getResourceContent((String)"bowpwd-sha256.min.js") + String.format(";window.bow.bowpwd('','%s','%s','%s','%s','%s');", auth.getMaxLength(), auth.getPrefix(), auth.getInclude(), auth.getExclude(), auth.getSuffix());
            result = BowUtils.toScriptlet((String)js);
        }
        catch (Exception eee) {
            log.info((Object)"Can't create scriptlet password", (Throwable)eee);
        }
        return result;
    }

    public static String scriptletAdd(String bowUrl, String token) {
        String result = "";
        try {
            String js = BowUtils.getResourceContent((String)"bowadd.min.js") + String.format(";window.bow.bowadd('%s','%s',true,true);", bowUrl, token);
            result = BowUtils.toScriptlet((String)js);
        }
        catch (Exception eee) {
            log.info((Object)"Can't create scriptlet add", (Throwable)eee);
        }
        return result;
    }

    public static String scriptPassword(BowAuthentication auth) {
        String result = "";
        try {
            String script = BowUtils.getResourceContent((String)"bowpwd.sh") + String.format("compute '%s' '%s' '%s' '%s' '%s' \"$DOMAIN\" \"$PASSWD\"", auth.getMaxLength(), auth.getPrefix(), auth.getInclude(), auth.getExclude(), auth.getSuffix());
            String b64 = Base64.encodeBase64URLSafeString((byte[])script.getBytes());
            result = "data:application/x-shellscript;base64," + b64;
        }
        catch (Exception eee) {
            log.info((Object)"Can't create scriptlet password", (Throwable)eee);
        }
        return result;
    }

    public static String toScriptlet(String js) throws URISyntaxException {
        URI uri = new URI("javascript", js, null);
        String result = uri.toASCIIString();
        return result;
    }

    public static String toBase64(byte[] b) {
        return Base64.encodeBase64String((byte[])b);
    }

    public static Date normalizeDate(Date date) {
        Date result = date;
        if (result == null) {
            result = new Date();
        }
        return result;
    }

    public static String normalizeString(String s) {
        String result = StringUtils.trimToEmpty((String)s);
        return result;
    }

    public static String normalizeUrl(String url) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)url) && !(result = url.trim()).matches("[a-z]+://.+")) {
            result = "http://" + result;
        }
        return result;
    }

    public static Set<String> getWords(String tags) {
        String[] words = StringUtils.split((String)tags);
        words = ArrayUtils.nullToEmpty((String[])words);
        HashSet<String> result = new HashSet<String>(Arrays.asList(words));
        result.remove("");
        result.remove(null);
        return result;
    }

    public static Set<String> getUsers(Set<String> tags) {
        HashSet<String> result = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(tags)) {
            for (String t : tags) {
                if (!StringUtils.startsWith((CharSequence)t, (CharSequence)"#")) continue;
                result.add(StringUtils.substringAfter((String)t, (String)"#"));
            }
        }
        return result;
    }

    public static Set<String> getGroups(Set<String> tags) {
        HashSet<String> result = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(tags)) {
            for (String t : tags) {
                if (!StringUtils.startsWith((CharSequence)t, (CharSequence)"@")) continue;
                result.add(StringUtils.substringAfter((String)t, (String)"@"));
            }
        }
        return result;
    }

    public static boolean isPublicGroup(BowGroup g) {
        Set reader = g.getReader();
        boolean result = CollectionUtils.isNotEmpty((Collection)reader) && reader.contains("all");
        return result;
    }

    public static String formatDate(Date date) {
        String result = DateFormatUtils.format((Date)date, (String)"yyyy/MM/dd");
        return result;
    }

    public static String generateToken() {
        UUID uuid = UUID.randomUUID();
        String tokenGenerated = uuid.toString();
        tokenGenerated = StringUtil.encodeMD5((String)tokenGenerated);
        return tokenGenerated;
    }

    public static String redirectTo(String tagLine, String fullTextLine) {
        String result = BowUtils.redirectTo(null, (String)tagLine, (String)fullTextLine);
        return result;
    }

    public static String redirectTo(List<String> listId, String tagLine, String fullTextLine) {
        String result = "home.action";
        boolean listIdNotEmpty = CollectionUtils.isNotEmpty(listId);
        boolean tagLineNotBlank = StringUtils.isNotBlank((CharSequence)tagLine);
        boolean fullTextLineNotBlank = StringUtils.isNotBlank((CharSequence)fullTextLine);
        if (listIdNotEmpty || tagLineNotBlank || fullTextLineNotBlank) {
            result = result + "?";
            String sep = "";
            if (listIdNotEmpty) {
                for (String id : listId) {
                    result = result + sep + "listId=" + id;
                    sep = "&";
                }
            }
            if (tagLineNotBlank) {
                result = result + sep + "tagLine=" + tagLine;
                sep = "&";
            }
            if (fullTextLineNotBlank) {
                result = result + sep + "fullTextLine=" + fullTextLine;
            }
        }
        return result;
    }

    public static BowUser checkToken(BowSession session, String token) {
        BowUser result = null;
        if (BowUtils.checkTemporaryToken((BowSession)session, (String)token) || BowUtils.checkPermanentToken((BowSession)session, (String)token)) {
            result = session.getUser();
        }
        return result;
    }

    protected static boolean checkPermanentToken(BowSession session, String token) {
        WikittyQuery criteria;
        BowUser user;
        BowProxy proxy = session.getProxy();
        boolean result = false;
        if (token != null && (user = (BowUser)proxy.findByQuery(BowUser.class, criteria = ((WikittyQueryMaker)new WikittyQueryMaker().eq("BowUser.permanentToken", (Object)token)).end())) != null) {
            session.setUser(user);
            result = true;
        }
        return result;
    }

    protected static boolean checkTemporaryToken(BowSession session, String token) {
        String temporaryToken = session.getTemporaryToken();
        boolean result = temporaryToken != null && temporaryToken.equals(token);
        return result;
    }
}

