/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowAuthentication;
import org.chorem.bow.BowAuthenticationImpl;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowPreference;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSearchPrefix;
import org.chorem.bow.BowSearchPrefixImpl;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.WikittyGroup;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.services.WikittySecurityUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BowSession
implements Serializable {
    private static final Log log = LogFactory.getLog(BowSession.class);
    private static final String BOW_SESSION_KEY = BowSession.class.getSimpleName();
    private static final long serialVersionUID = 1L;
    protected BowProxy proxy = BowProxy.getInstance(null);
    protected BowUser user;
    protected String temporaryToken;
    protected boolean admin;

    public static void invalidate(Map<String, Object> session) {
        session.remove(BOW_SESSION_KEY);
    }

    public static BowSession getBowSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        BowSession result = BowSession.getBowSession((HttpSession)session);
        return result;
    }

    public static BowSession getBowSession(HttpSession httpSession) {
        BowSession result = (BowSession)httpSession.getAttribute(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            httpSession.setAttribute(BOW_SESSION_KEY, (Object)result);
        }
        return result;
    }

    public static BowSession getBowSession(Map<String, Object> session) {
        BowSession result = (BowSession)session.get(BOW_SESSION_KEY);
        if (result == null) {
            result = new BowSession();
            session.put(BOW_SESSION_KEY, result);
        }
        return result;
    }

    public BowProxy getProxy() {
        return this.proxy;
    }

    public BowUser getUser() {
        return this.user;
    }

    public void removeAndAddTag(List<String> toRemove, List<String> toAdd) {
        WikittyQuery c = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("BowBookmark")).containsOne("WikittyLabel.labels", toRemove)).eq("WikittyAuthorisation.owner", (Object)this.user)).end();
        WikittyQueryResult searchResult = this.proxy.findAllByQuery(WikittyLabel.class, c);
        ArrayList<WikittyLabel> toStore = new ArrayList<WikittyLabel>();
        for (WikittyLabel label : searchResult) {
            toStore.add(label);
            HashSet<String> l = label.getLabels();
            if (l == null) continue;
            l = new HashSet<String>(l);
            l.removeAll(toRemove);
            if (CollectionUtils.isNotEmpty(toAdd)) {
                l.addAll(toAdd);
            }
            label.setLabels(l);
        }
        this.proxy.store(toStore);
    }

    public BowAuthentication getAuthentication() {
        BowUser user = this.getUser();
        BowAuthentication result = this.getAuthentication(user.getWikittyId());
        return result;
    }

    public BowAuthentication getAuthentication(String wikittyId) {
        WikittyQuery criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("BowAuthentication")).eq((Element)BowAuthentication.ELEMENT_FIELD_BOWAUTHENTICATION_TARGET, (Object)wikittyId)).end();
        BowAuthentication result = (BowAuthentication)this.getProxy().findByQuery(BowAuthentication.class, criteria);
        if (result == null) {
            BowUser user = this.getUser();
            result = new BowAuthenticationImpl();
            result.setMaxLength(15);
            result.setTarget(wikittyId);
            result.setOwner((WikittyUser)user);
            result.setReader(Collections.singleton(user.getWikittyId()));
        }
        return result;
    }

    public List<BowSearchPrefix> getSearchPrefix() {
        BowUser user = this.getUser();
        WikittyQuery criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("BowSearchPrefix")).eq("BowSearchPrefix.bowUser", (Object)user.getWikittyId())).end().setSortAscending(new Element[]{BowSearchPrefix.ELEMENT_FIELD_BOWSEARCHPREFIX_PREFIX});
        WikittyQueryResult result = this.getProxy().findAllByQuery(BowSearchPrefix.class, criteria);
        ArrayList<BowSearchPrefix> prefix = new ArrayList<BowSearchPrefix>(result.getAll());
        log.debug((Object)("####################### prefix number ################### " + prefix.size()));
        if (prefix.isEmpty()) {
            String userId = user.getWikittyId();
            String prefixSeparator = BowConfig.getPrefixSeparator();
            BowSearchPrefixImpl pWeb = new BowSearchPrefixImpl();
            pWeb.setBowUser(userId);
            pWeb.setPrefix(BowConfig.getWebSearchPrefix() + prefixSeparator);
            pWeb.setSearch(BowConfig.getSearchEngine());
            BowSearchPrefixImpl pTag = new BowSearchPrefixImpl();
            pTag.setBowUser(userId);
            pTag.setPrefix(BowConfig.getTagSearchPrefix() + prefixSeparator);
            pTag.setSearch("search.tag");
            pTag.setSuggestion("suggestion.tag");
            BowSearchPrefixImpl pFullText = new BowSearchPrefixImpl();
            pFullText.setBowUser(userId);
            pFullText.setPrefix(BowConfig.getFullTextSearchPrefix() + prefixSeparator);
            pFullText.setSearch("search.fulltext");
            pFullText.setSuggestion("suggestion.fulltext");
            BowSearchPrefixImpl pAlias = new BowSearchPrefixImpl();
            pAlias.setBowUser(userId);
            pAlias.setPrefix(BowConfig.getAliasPrefix() + prefixSeparator);
            pAlias.setSearch("search.alias");
            pAlias.setSuggestion("suggestion.alias");
            BowSearchPrefixImpl pAdd = new BowSearchPrefixImpl();
            pAdd.setBowUser(userId);
            pAdd.setPrefix(BowConfig.getAddPrefix() + prefixSeparator);
            pAdd.setSearch("search.add");
            pAdd.setSuggestion("suggestion.add");
            BowSearchPrefixImpl pDefault = new BowSearchPrefixImpl();
            pDefault.getWikitty().replaceWith(pWeb.getWikitty(), true);
            pDefault.setPrefix("");
            BowSearchPrefixImpl pDefaultPrefix = new BowSearchPrefixImpl();
            pDefaultPrefix.getWikitty().replaceWith(pTag.getWikitty(), true);
            pDefaultPrefix.setPrefix(prefixSeparator);
            this.proxy.store((BusinessEntity)pWeb, (BusinessEntity)pTag, (BusinessEntity[])new BowSearchPrefixImpl[]{pFullText, pAlias, pAdd, pDefault, pDefaultPrefix});
            prefix.add((BowSearchPrefix)pWeb);
            prefix.add((BowSearchPrefix)pTag);
            prefix.add((BowSearchPrefix)pFullText);
            prefix.add((BowSearchPrefix)pAlias);
            prefix.add((BowSearchPrefix)pDefault);
            prefix.add((BowSearchPrefix)pDefaultPrefix);
        }
        return prefix;
    }

    public void setUser(BowUser user) {
        String login = user.getLogin();
        Object[] admins = BowConfig.getAdmins();
        boolean isAdmin = ArrayUtils.contains((Object[])admins, (Object)login);
        this.setAdmin(isAdmin);
        this.checkPreference((BowPreference)user);
        if (!ObjectUtils.equals((Object)this.user, (Object)user)) {
            String temporaryToken = BowUtils.generateToken();
            this.setTemporaryToken(temporaryToken);
            String wikittyToken = this.proxy.getSecurityToken(user.getWikittyId());
            this.proxy.setSecurityToken(wikittyToken);
            if (isAdmin) {
                this.checkAppAdminGroup(user, (String[])admins);
            }
        }
        this.user = user;
    }

    protected void checkAppAdminGroup(BowUser user, String ... adminsLogin) {
        boolean mustSave = false;
        WikittyGroup adminGroup = WikittySecurityUtil.getAppAdminGroup((WikittyClient)this.proxy);
        if (adminGroup == null) {
            adminGroup = WikittySecurityUtil.createAppAdminGroup((WikittyUser)user);
            mustSave = true;
        }
        if (ArrayUtils.isNotEmpty((Object[])adminsLogin)) {
            List<String> admins = Arrays.asList(adminsLogin);
            WikittyQuery criteria = ((WikittyQueryMaker)new WikittyQueryMaker().containsOne((Element)WikittyUser.ELEMENT_FIELD_WIKITTYUSER_LOGIN, admins)).end();
            List adminsId = this.proxy.findAllByQuery(criteria).getAll();
            if (adminGroup.getMembers().size() != adminsId.size() || !adminGroup.getMembers().containsAll(adminsId)) {
                adminGroup.setMembers(new HashSet(adminsId));
                mustSave = true;
            }
        }
        if (mustSave) {
            this.proxy.store((BusinessEntity)adminGroup);
        }
    }

    protected void checkPreference(BowPreference preference) {
        if (preference.getBookmarks() <= 0) {
            preference.setBookmarks(100);
        }
        if (preference.getTags() <= 0) {
            preference.setTags(100);
        }
        if (preference.getColors() == null) {
            preference.setColors("");
        }
    }

    public String getPermanentToken() {
        return this.getUser().getPermanentToken();
    }

    public String getTemporaryToken() {
        return this.temporaryToken;
    }

    public void setTemporaryToken(String temporaryToken) {
        this.temporaryToken = temporaryToken;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }
}

