package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyUtil;

@Generated(value = "org.nuiton.wikitty.generator.WikittyHelperGenerator", date = "Tue Jul 21 11:37:45 CEST 2015")
public class WikittyGroupHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private WikittyGroupHelper() {// empty
}

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
        return value;
}

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME, name);
        return oldValue;
}

    public static Set<String> getMembers(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, String.class);
        return result;
}

    public static void setMembers(Wikitty wikitty, Set<String> members) {
        wikitty.setField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, members);
}

    public static void addAllMembers(Wikitty wikitty, Collection<String> members) {
        if(members != null){
            for (String v:members){
                addMembers(wikitty, v);
            }
        }
}

    public static void addMembers(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, v);
        }
}

    public static void removeMembers(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, v);
        }
}

    public static void clearMembers(Wikitty wikitty) {
        wikitty.clearField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
}

    public static Set<Wikitty> getMembers(Wikitty wikitty, boolean exceptionIfNotLoaded) {
        Set<Wikitty> result = wikitty.getFieldAsWikittySet(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, exceptionIfNotLoaded);
        return result;
}

    public static void setMembersEntity(Wikitty wikitty, Collection<Wikitty> members) {
        wikitty.setField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, members);
}

    public static void addAllMembersEntity(Wikitty wikitty, Collection<Wikitty> members) {
        if(members != null){
            for (Wikitty v:members){
                addMembers(wikitty, v);
            }
        }
}

    public static void addMembers(Wikitty wikitty, Wikitty... element) {
        for (Wikitty v : element) {
            wikitty.addToField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, v);
        }
}

    public static void removeMembers(Wikitty wikitty, Wikitty... element) {
        for (Wikitty v : element) {
            wikitty.removeFromField(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, v);
        }
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
            Object f2 = w2.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
            Object f2 = w2.getFieldAsObject(WikittyGroup.EXT_WIKITTYGROUP, WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyGroup.EXT_WIKITTYGROUP);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyGroupAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * supprime les extensions de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void removeExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyGroupAbstract.extensions) {
            wikitty.removeExtension(ext.getName());
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(WikittyGroup.EXT_WIKITTYGROUP);
}

} //WikittyGroupHelper
