/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.preference;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

/**
 * @author poussin
 * @version $Revision$
 *          <p/>
 *          Last update: $Date$
 *          by : $Author$
 */
public class UpdateUserAction extends PreferenceBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(UpdateUserAction.class);

    private static final long serialVersionUID = 1L;

    /**
     * ACTION STRUTS
     * <p/>
     * Modifie l'email et le password si necessaire. Si la modif est impossible
     * email deja utilise, ou mauvais password, alors la methode return ERROR
     * Si tout ce passe bien, la methode retourne SUCCES
     *
     * @return
     */
    @Override
    public String execute() {
        String result = SUCCESS;

        try {
            BowSession session = getBowSession();
            BowProxy proxy = session.getProxy();
            BowUser user = session.getUser();

            if (StringUtils.isNotBlank(email)) {
                WikittyQuery criteria = new WikittyQueryMaker()
                        .eq(BowUser.FQ_FIELD_WIKITTYUSER_LOGIN, email).end();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Try to find user with email: '%s'", email));
                }
                BowUser find = getBowProxy().findByQuery(BowUser.class, criteria);

                //If this email address isn't already used (or if it hasn't changed)
                if (find == null || find.getLogin().equals(user.getLogin())) {
                    email = email.trim();
                    user.setLogin(email);
                } else {
                    // this email address is already used by someone else
                    setEmail(user.getLogin());

                    // TODO poussin 20110818 addFieldError don't work (no message on web page :(
                    // add addActionError to prevent addFieldError that don't work
                    addFieldError("email", t("bow.preferences.emailAldyExists"));
                    addActionError(t("bow.preferences.emailAldyExists"));
                    result = ERROR;
                }
            }

            if (SUCCESS.equals(result)
                && StringUtils.isNotBlank(newPassword)
                && StringUtils.isNotBlank(confirmNewPassword)
                && StringUtils.isNotBlank(currentPassword)) {
                if (newPassword.equals(confirmNewPassword)) {
                    currentPassword = StringUtil.encodeMD5(currentPassword);
                    if (currentPassword.equals(user.getPassword())) {
                        user.setPassword(StringUtil.encodeMD5(newPassword));
                    } else {
                        // TODO poussin 20110818 addFieldError don't work (no message on web page :(
                        // add addActionError to prevent addFieldError that don't work
                        addFieldError("currentPassword", t("bow.preferences.badCurrentPassword"));
                        addActionError(t("bow.preferences.badCurrentPassword"));
                        result = ERROR;
                    }
                }
            }
            if (SUCCESS.equals(result)) {
                user = proxy.store(user);
                getBowSession().setUser(user);
                addActionMessage(t("bow.preferences.update.successful"));
            }
        } catch (Exception eee) {
            result = ERROR;
            addActionError(t("bow.error.internal"));
            log.error("Can't change site preference", eee);
        } finally {
            // on recharge les data apres l'action pour l'affichage
            // sauf celle du user qui sont deja les bonnes
            load(PreferenceType.USER_PREF);
        }

        return result;
    }

}
