/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.preference;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSearchPrefix;
import org.chorem.bow.BowSearchPrefixImpl;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;

/**
 * @author poussin
 * @version $Revision$
 *          <p/>
 *          Last update: $Date$
 *          by : $Author$
 */
public class UpdateSiteAction extends PreferenceBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(UpdateSiteAction.class);

    private static final long serialVersionUID = 1L;

    protected int removedPrefix = -1;

    public void setRemovedPrefix(int removedPrefix) {
        this.removedPrefix = removedPrefix;
    }

    public int getRemovedPrefix() {
        return removedPrefix;
    }
    
    /**
     * ACTION STRUTS
     * <p/>
     * Action executer lorsque l'utilisateur demande la page
     */
    @Override
    public String execute() {
        String result = SUCCESS;

        try {
            BowSession session = getBowSession();
            BowProxy proxy = session.getProxy();
            BowUser preference = session.getUser();

            preference.setScreenshot(screenshot);
            preference.setFavicon(favicon);
            
            preference.setColors(colors);
            if (StringUtils.isNotBlank(tagsNb)) {
                preference.setTags(Integer.valueOf(tagsNb));
            }
            if (StringUtils.isNotBlank(bookmarksHomePage)) {
                preference.setBookmarks(Integer.valueOf(bookmarksHomePage));
            }

            searchPrefix = proxy.store(searchPrefix);

            preference = proxy.store(preference);
            getBowSession().setUser(preference);
        } catch (Exception eee) {
            result = ERROR;
            addActionError(t("bow.error.internal"));
            log.error("Can't change site preference", eee);
        } finally {
            // on recharge les data apres l'action pour l'affichage
            // sauf celle du site qui sont deja les bonnes
            load(PreferenceType.SITE_PREF);
        }
        return result;
    }


    public String addPrefix() {
        String result = SUCCESS;
        try {
            BowSession session = getBowSession();
            BowProxy proxy = session.getProxy();

            BowSearchPrefix prefix = new BowSearchPrefixImpl();
            prefix.setBowUser(session.getUser().getWikittyId());

            searchPrefix.add(prefix);
            proxy.store(searchPrefix);
            // force reload to have right order by
            searchPrefix = null;
        } catch (Exception eee) {
            result = ERROR;
            addActionError(t("bow.error.internal"));
            log.error("Can't change site preference", eee);
        } finally {
            // on recharge les data apres l'action pour l'affichage
            // sauf celle du site qui sont deja les bonnes
            load(PreferenceType.SITE_PREF);
        }
        return result;
    }

    public String removePrefix() {
        String result = SUCCESS;
        try {
            log.debug("########################## removedPrefix ############## " + removedPrefix);
            if (removedPrefix >= 0) {
                BowSession session = getBowSession();
                BowProxy proxy = session.getProxy();

                BowSearchPrefix p = searchPrefix.remove(removedPrefix);
                proxy.delete(p);
            }
        } catch (Exception eee) {
            result = ERROR;
            addActionError(t("bow.error.internal"));
            log.error("Can't change site preference", eee);
        } finally {
            // on recharge les data apres l'action pour l'affichage
            // sauf celle du site qui sont deja les bonnes
            load(PreferenceType.SITE_PREF);
        }
        return result;
    }
}
