/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.opensearch;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.chorem.bow.BowSearchPrefix;
import org.chorem.bow.action.BowBaseAction;
import java.util.List;
import java.util.ListIterator;

/**
 * Traite toutes les demandes faite via l'opensearch
 * a:, :, t:, ...
 * <p/>
 * Cette classe recherche le prefix et redirige vers la bonne methode execute.
 * Les classes filles n'ont plus qu'a implanter les methodes
 *
 * @author poussin
 */
abstract public class OpenSearchBaseAction extends BowBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(OpenSearchBaseAction.class);

    private static final long serialVersionUID = 1L;

    /** [in] le token d'identification */
    protected String token;

    /** [in] la ligne de recherche soumise par l'utilisateur */
    protected String q;

    public String getQ() {
        return q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    /** @return the token */
    public String getToken() {
        return token;
    }

    /** @param token the token to set */
    public void setToken(String token) {
        this.token = token;
    }

    abstract protected String executePrefixAction(BowSearchPrefix foundPrefix, String query);

    @Override
    public String execute() {
        log.debug("######################### OpenSearchBaseAction enter #################" + q);
        log.debug("param:" + ServletActionContext.getRequest().getParameterMap());

        BowSearchPrefix defaultPrefix = null;
        BowSearchPrefix foundPrefix = null;
        String query;

        // prefixes is ordered in lexical order, iterate in reverse order to match per example !gi before !g
        List<BowSearchPrefix> prefixes = getBowSession().getSearchPrefix();
        for (ListIterator<BowSearchPrefix> i=prefixes.listIterator(prefixes.size()); i.hasPrevious();) {
            BowSearchPrefix prefix = i.previous();
            String p = prefix.getPrefix();
            if (StringUtils.isBlank(p)) {
                defaultPrefix = prefix;
            } else if (StringUtils.startsWith(q, p)) {
                foundPrefix = prefix;
                break;
            }
        }

        if (foundPrefix == null) {
            foundPrefix = defaultPrefix;
        }

        if (foundPrefix == null) {
            query = q;
        } else {
            query = StringUtils.substringAfter(q, foundPrefix.getPrefix());
        }

        System.out.println("######################### OpenSearchBaseAction #################" + query + " - " + foundPrefix);

        String result = executePrefixAction(foundPrefix, query);
        return result;
    }

}
