/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.bow.action.login;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUserImpl;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

/**
 * authentifie l'utilisateur et place son objet User dans la bow session
 *
 * @author poussin
 */
public class LoginAction extends BowBaseAction {

    private static final long serialVersionUID = 6891064800288772246L;
    private static Log log = LogFactory.getLog(LoginAction.class);

    protected String email;

    protected String password;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * Check password in solr index, if fail try to check password admin in config file
     *
     * @param email    non null et non vide email
     * @param password non null et non vide email
     * @return
     */
    protected BowUser checkLogin(String email, String password) {
        BowUser result;

        BowProxy proxy = getBowProxy();
        WikittyQuery criteria = new WikittyQueryMaker().and()
                .eq(BowUser.FQ_FIELD_WIKITTYUSER_LOGIN, email)
                .eq(BowUser.FQ_FIELD_WIKITTYUSER_PASSWORD, password).end();
        result = proxy.findByQuery(BowUser.class, criteria);

        if (result == null) {
            // failback: try to authenticate admin with config info
            String configPassword = BowConfig.getAdminPassword(email);
            log.info(String.format("failback password: '%s' configPassword: '%s'",
                                   password, configPassword));
            if (password.equals(configPassword)) {
                // admin authenticate with config, this is possible when
                // solr index is corrupted or missed. Admin must go to admin
                // page en recreate index
                result = new BowUserImpl();
                result.setLogin(email);
                result.setPassword(configPassword);
                addActionMessage(t("bow.login.admin.failback"));
                log.warn(t("bow.login.admin.failback"));
            } else {
                addActionError(t("bow.login.authenticationFailure"));
            }
        }
        return result;
    }

    /** Authenticates the user if his email and password are valid */
    @Override
    public String execute() {
        String result = INPUT;

        try {
            if (StringUtils.isNotBlank(email)) {
                email = email.trim();

                if (StringUtils.isNotEmpty(password)) {
                    String md5 = StringUtil.encodeMD5(password);
                    BowUser user;

                    user = checkLogin(email, md5);
                    if (user != null) {
                        getBowSession().setUser(user);
                        result = SUCCESS;
                    }
                }
            }
        } catch (Exception eee) {
            addActionError(t("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        return result;
    }
}
