/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.group;

import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowGroup;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.services.WikittyServiceAuthorisation;

/**
 * Used view groups
 *
 * @author poussin
 * @version $Revision$
 *          <p/>
 *          Last update: $Date$
 *          by : $Author$
 */
public class GroupViewAction extends BowBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(GroupViewAction.class);

    private static final long serialVersionUID = 1L;

    protected List<BowGroup> groups;

    public List<BowGroup> getGroups() {
        return groups;
    }

    @Override
    public String execute() throws Exception {
        String result = SUCCESS;
        try {

            BowSession session = getBowSession();

            BowUser user = session.getUser();
            BowProxy proxy = session.getProxy();

            WikittyQuery criteria = new WikittyQueryMaker().and()
                    .exteq(BowGroup.EXT_BOWGROUP)
                    .eq(BowGroup.ELEMENT_FIELD_WIKITTYGROUP_MEMBERS, user).end();
            WikittyQueryResult<String> groupsId = proxy.findAllByQuery(criteria);
            groups = proxy.restore(BowGroup.class, groupsId.getAll(), "WikittyGroup.members");

            if (log.isDebugEnabled()) {
                log.debug(String.format("Group found='%s'" + groups.size()));
            }

        } catch (Exception eee) {
            addActionError(t("bow.error.internal"));
            log.error(eee.getMessage(), eee);
            result = ERROR;
        }
        return result;
    }

}
