/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.bookmark;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;

/**
 * Met a jour le screenshot d'un bookmark
 *
 * @author poussin
 */
public class ScreenshotAction extends BowBaseAction {

    private static final long serialVersionUID = 820566716695285561L;
    private static final Log log = LogFactory.getLog(ScreenshotAction.class);

    protected String id;

    protected String redirectTo;

    /** @return the id */
    public String getId() {
        return id;
    }

    /** @param id the bookmarkId to set */
    public void setId(String id) {
        this.id = id;
    }

    /** @return the redirectTo */
    public String getRedirectTo() {
        return redirectTo;
    }

    /** Removes a bookmark */
    @Override
    public String execute() {
        if (StringUtils.isNotEmpty(id)) {
            try {
                BowProxy proxy = getBowProxy();
                BowBookmark bookmark = proxy.restore(BowBookmark.class, id);
                if (bookmark != null) {
                    boolean changed = false;
                    String link = bookmark.getLink();

                    // on essaie de prendre l'image
                    byte[] screenshot = BookmarkUtils.getScreenshot(link);
                    if (ArrayUtils.isNotEmpty(screenshot) ) {
                        bookmark.setScreenshot(screenshot);
                        changed = true;
                        addActionMessage(t("bow.bookmark.screenshot.updated.successful"));
                    }
                    // on essaie de recuperer le favicone
                    byte[] favicone = BookmarkUtils.getFavicon(link);
                    if (ArrayUtils.isNotEmpty(favicone)) {
                        bookmark.setFavicon(favicone);
                        changed = true;
                        addActionMessage(t("bow.bookmark.favicon.updated.successful"));
                    }

                    if (changed) {
                        proxy.store(bookmark);
                    }
                }
            } catch (Exception eee) {
                addActionError(t("bow.error.internal"));
                log.error("Can't do action", eee);
            }
        }
        redirectTo = BowUtils.redirectTo(tagLine, fullTextLine);
        return SUCCESS;
    }
}
