/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.bookmark;

import com.opensymphony.xwork2.ActionContext;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSearchResult;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryResult;

/**
 * Prepare l'affichage de la page d'accueil
 *
 * @author poussin
 */
public class HomeAction extends BowBaseAction {

    private static final Log log = LogFactory.getLog(HomeAction.class);

    private static final TimeLog timeLog = new TimeLog(HomeAction.class);

    private static final long serialVersionUID = -3735250067223062719L;

    public static HomeAction getAction() {
        Object action = ActionContext.getContext().get(CONTEXT_ACTION_KEY);
        return (HomeAction) action;
    }

    protected String addTag;

    protected BowSearchResult searchResult;

    public String getAddTag() {
        return addTag;
    }

    public void setAddTag(String addTag) {
        this.addTag = addTag;
    }

    public BowSearchResult getSearchResult() {
        return searchResult;
    }

    public void setSearchResult(BowSearchResult searchResult) {
        this.searchResult = searchResult;
    }

    /** Load all data necessary form Home page */
    protected void load() {
        // on ajoute les tags qui doivent faire parti de ne nouvelle recherche
        // on restocke dans tagLine pour que la bonne info reapparaisse
        // a l'utilisateur
        tagLine = StringUtils.join(new String[]{tagLine, addTag}, " ").trim();

        // si l'ordre souhaite n'existe pas, on utilise l'ordre par defaut
        if (!getPossibleOrder().contains(order)) {
            // default sort order
            // TODO poussin 20110815 rendre configurable par l'utilisateur l'ordre par defaut qu'il prefere
            order = "descClick";
        }

        BowSession session = getBowSession();

        BowUser user = session.getUser();
        BowProxy proxy = session.getProxy();

        WikittyQuery criteria = BookmarkUtils.getBookmarkListCriteriaByUser(
                user, listId, tagLine, fullTextLine, order, first);
        WikittyQueryResult<BowBookmark> result =
                proxy.findAllByQuery(BowBookmark.class, criteria);

        searchResult = new BowSearchResult(result, tagLine);
    }

    /** Initializes everything before displaying the home page */
    @Override
    public String execute() {
        long start = TimeLog.getTime();
        try {
            load();
        } catch (Exception eee) {
            addActionError(t("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        timeLog.log(start, "execute");
        return SUCCESS;
    }
}
