/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.bookmark;

import org.apache.commons.lang3.StringUtils;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowProxy;
import org.nuiton.wikitty.query.WikittyQuery;

/**
 * Supprime des bookmarks qui satisfont le critere de recherche.
 *
 * @author poussin
 */
public class DeleteSearchResultsAction extends BowBaseAction {

    private static final long serialVersionUID = -3903724044644625507L;

    private static Log log = LogFactory.getLog(DeleteSearchResultsAction.class);
    
    /** Deletes the search results */
    public String execute() {
        try {
            if (StringUtils.isNotBlank(tagLine)
                || StringUtils.isNotBlank(fullTextLine)) {
                BowUser user = getBowSession().getUser();
                // FIXME poussin 20110817 ATTENTION, la recherche remonte
                // potentiellement des bookmarks qui ne nous appartiennent pas,
                // dans ce cas, ne faudrait-il pas seulement ce supprimer des
                // reader/write/admin ?
                WikittyQuery criteria = BookmarkUtils.getBookmarkListCriteriaByUser(
                        user, listId, tagLine, fullTextLine, null, 0);
                criteria.setLimit(Integer.MAX_VALUE);
                
                BowProxy proxy = getBowProxy();
                List<String> ids = proxy.findAllByQuery(criteria).getAll();

                if (log.isDebugEnabled()) {
                    log.debug("Will delete " + ids.size() + " bookmarks");
                }

                proxy.delete(ids);
                addActionMessage(t("bow.search.results.deleted"));
            }
        } catch (Exception eee) {
            addActionError(t("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        return SUCCESS;
    }
}
