/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.SessionAware;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;
import org.nuiton.web.struts2.BaseAction;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.chorem.bow.BookmarkUtils;

/**
 * Base class which must be extended by every action
 * Overrides the Struts2 methods to render text in order to explicitly show
 * the missing i18n translations
 * Allows access to the session and the proxy
 */
public class BowBaseAction extends BaseAction implements SessionAware {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(BowBaseAction.class);

    final static protected String CONTEXT_ACTION_KEY = "action";

    public static final String UNTRANSLATED_MARKER = "???";

    /** Liste des valeurs de tri possible */
    // perhaps use enumeration ?
    final static protected List<String> possibleOrder = Arrays.asList(
            "ascName", "descName", "ascClick", "descClick", "ascDate", "descDate");

    public static List<String> getPossibleOrder() {
        return possibleOrder;
    }

    protected transient Map<String, Object> session;

    /** Configuration, default null for lazy loading */
    protected transient BowConfig config;

    protected transient BookmarkUtils bookmarkUtils;

    /** des identifiants de bookmark a recherche explicitemnet */
    protected List<String> listId;

    /** Les tags a recherche separer par un espace */
    protected String tagLine;

    /** La ligne de recherche fulltext */
    protected String fullTextLine;

    /** l'ordre d'affichage des resultats */
    protected String order;

    /**
     * indice du 1er element a recuperer, on en recupere le nombre defini
     * dans les preferences utilisateur. Par defaut on prend a partir du 1er
     * donc l'indice 0.
     */
    protected int first;

    public BowConfig getConfig() {
        if (config == null) {
            config = new BowConfig();
        }
        return config;
    }

    public BowSession getBowSession() {
        BowSession result = BowSession.getBowSession(session);
        return result;
    }

    public BowProxy getBowProxy() {
        BowProxy result = getBowSession().getProxy();
        return result;
    }

    public BookmarkUtils getBookmarkUtils() {
        if (bookmarkUtils == null) {
            bookmarkUtils = new BookmarkUtils();
        }
        return bookmarkUtils;
    }

    @Override
    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public List<String> getListId() {
        return listId;
    }

    public void setListId(List<String> listId) {
        this.listId = listId;
    }

    /** @return the tagLine */
    public String getTagLine() {
        return tagLine;
    }

    /** @param tagLine the tagLine to set */
    public void setTagLine(String tagLine) {
        this.tagLine = tagLine;
    }

    /** @return the fullTextLine */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /** @param fullTextLine the fullTextLine to set */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public int getFirst() {
        return first;
    }

    public void setFirst(int first) {
        this.first = first;
    }

}
