/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryResult;

/**
 * Handles RSS flux demande
 * - tagLine
 * - fullTextLine
 * - count: number of bookmark to retrieve
 *
 * @author poussin
 * @version $Revision$
 *          <p/>
 *          Last update: $Date$
 *          by : $Author$
 */
public class AtomAction extends BowBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(AtomAction.class);

    private static final long serialVersionUID = 1L;

    protected int count = 15;

    protected List<BowBookmark> bookmarks;

    protected Date date;

    protected String redirectTo = "/";

    public String getRedirectTo() {
        return redirectTo;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<BowBookmark> getBookmarks() {
        return bookmarks;
    }

    public Date getDate() {
        return date;
    }

    @Override
    public String execute() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Rss for tags='%' fulltext='%s' count='%s'" + tagLine, fullTextLine, count));
        }
        String result = SUCCESS;
        try {

            BowSession session = getBowSession();

            BowUser user = session.getUser();
            BowProxy proxy = session.getProxy();

            WikittyQuery criteria = BookmarkUtils.getBookmarkListCriteriaByUser(
                    user, listId, tagLine, fullTextLine, "descDate", 0);
            criteria.setLimit(count);
            WikittyQueryResult<String> bookmarksId = proxy.findAllByQuery(criteria);
            bookmarks = proxy.restore(BowBookmark.class, bookmarksId.getAll(), "WikittyAuthorisation.owner");
            date = new Date();

            if (log.isDebugEnabled()) {
                log.debug(String.format("Rss found='%s'" + bookmarks.size()));
            }

        } catch (Exception eee) {
            addActionError(t("bow.error.internal"));
            log.error(eee.getMessage(), eee);
            result = ERROR;
        }
        return result;
    }

}
