/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import org.nuiton.config.ApplicationConfig;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.WikittyExtension;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRegistry;

/**
 * Proxy pour utiliser les wikitty convenablement initialise.
 *
 * @author poussin
 * @version $Revision$
 *          <p/>
 *          Last update: $Date$
 *          by : $Author$
 */
public class BowProxy extends WikittyClient {

    static protected WikittyService ws;

    protected BowProxy(ApplicationConfig config, WikittyService ws) {
        super(config, ws);
    }

    /**
     * Return instance of BowProxy with specified security token
     *
     * @param token
     * @return
     */
    public static BowProxy getInstance(String token) {
        ApplicationConfig config = BowConfig.getConfig();
        WikittyService ws = getWikittyService(config);
        BowProxy result = new BowProxy(config, ws);
        result.setSecurityToken(token);

        return result;
    }

    /**
     * Return WikittyService to use. This WikittyService is singleton.
     *
     * @param config
     * @return
     */
    static protected WikittyService getWikittyService(ApplicationConfig config) {
        if (ws == null) {
            synchronized (BowProxy.class) {
                if (ws == null) {
                    // on enregistre les classes qui feront la migration des données
                    // on enregistre la classe qui fera la migration des données
                    WikittyExtensionMigrationRegistry registry =
                            config.getObject(WikittyExtensionMigrationRegistry.class);
                    registry.put(BowPreference.EXT_BOWPREFERENCE, new BowMigrationPreference());

                    // enregistrement des extensions
                    List<WikittyExtension> extensions = new ArrayList<WikittyExtension>();
                    extensions.addAll(BowUserImpl.extensions); // inherit BowPreference, WikittyUser
                    extensions.addAll(BowImportImpl.extensions); // inherit BowBookmark, WikittyLabel, WikittyAuthorisation
                    extensions.addAll(BowSearchPrefixImpl.extensions); // inherit BowBookmark, WikittyLabel
                    extensions.addAll(BowGroupImpl.extensions); // inherit BowBookmark, WikittyLabel

                    ws = WikittyServiceFactory.buildWikittyService(config);
                    ws.storeExtension(null, extensions);
                }
            }
        }
        return ws;
    }

}
