/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.util.Properties;

public class BowMail {

    public static void sendMail(String sendToEmail, String mailSubject, String mailContent) throws MessagingException {
        String smtpServer = BowConfig.getSmtpServer();
        Properties properties = new Properties();
        properties.put("mail.smtp.host", smtpServer);

        Session session = Session.getDefaultInstance(properties, null);
        session.setDebug(true);

        Message msg = new MimeMessage(session);

        msg.addRecipient(Message.RecipientType.TO, new InternetAddress(sendToEmail));
        msg.setFrom(new InternetAddress(BowConfig.getAddressFrom()));
        msg.setSubject(mailSubject);
        msg.setContent(mailContent, "text/plain");
        Transport.send(msg);
    }
}
