/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;

import static org.nuiton.i18n.I18n.t;

/** Bow option definition. */
public enum BowConfigOption implements ConfigOptionDef {

    CONFIG_FILE(
            ApplicationConfig.CONFIG_FILE_NAME,
            t("bow.config.configFileName.description"),
            "bow.properties", String.class, false, false),
    APPLICATION_VERSION(
            "application.version",
            t("bow.config.application.version.description"),
            null, String.class, true, true),
    BOW_URL(
            "bow.url",
            t("bow.config.bow.url.description"),
            null, String.class, false, false),
    // For apache url rewriting
    ALIAS_URL(
            "alias.url",
            t("bow.config.alias.url.description"),
            "alias/", String.class, false, false),
    BOW_ALLOW_PUBLIC_GROUP(
            "bow.allow.public.group",
            t("bow.config.bow.allow.public.group.description"),
            "false", Boolean.class, false, false),
    BOW_SCREENSHOT_URL(
            "bow.screenshot.url",
            t("bow.config.bow.screenshot.url.description"),
            "http://screenshotweb.codelutin.com/screenshotweb.cgi?URL=%s&FILENAME=screenshot.png&VIEWPORT=1024*1182&CLIPRECT=0*0*1024*1182&SCALE=65x75", String.class, false, false),
    BOW_SMTPSERVER(
            "bow.smtpServer",
            t("bow.config.bow.smtpServer.description"),
            null, String.class, false, false),
    BOW_ADDRESSFROM(
            "bow.addressFrom",
            t("bow.config.bow.addressFrom.description"),
            null, String.class, false, false),
    BOW_ADMINS(
            "bow.admins",
            t("bow.config.bow.admins.description"),
            null, String.class, false, false),
    SEARCH_ENGINE(
            "search.engine",
            t("bow.config.search.engine.description"),
            null, String.class, false, false),
    TAG_SEARCH_URL(
            "bow.prefix.search.tag",
            t("bow.config.sprefix.search.tag.description"),
            "home.action?tagLine={searchTerms}", String.class, false, false),
    FULLTEXT_SEARCH_URL(
            "bow.prefix.search.fulltext",
            t("bow.config.bow.prefix.search.fulltext.description"),
            "home.action?fullTextLine={searchTerms}", String.class, false, false),
    ALIAS_SEARCH_URL(
            "bow.prefix.search.alias",
            t("bow.config.bow.prefix.search.alias.description"),
            "alias.action?alias={searchTerms}", String.class, false, false),
    SAVE_SEARCH_URL(
            "bow.prefix.search.add",
            t("bow.config.bow.prefix.search.add.description"),
            "addUrl.action?nameAndTags={searchTerms}", String.class, false, false),
    TAG_SUGGESTION_URL(
            "bow.prefix.suggestion.tag",
            t("bow.config.sprefix.suggestion.tag.description"),
            "suggestion-tag.action?q={searchTerms}", String.class, false, false),
    FULLTEXT_SUGGESTION_URL(
            "bow.prefix.suggestion.fulltext",
            t("bow.config.bow.prefix.suggestion.fulltext.description"),
            "suggestion-fulltext.action?q={searchTerms}", String.class, false, false),
    ALIAS_SUGGESTION_URL(
            "bow.prefix.suggestion.alias",
            t("bow.config.bow.prefix.suggestion.alias.description"),
            "suggestion-alias.action?q={searchTerms}", String.class, false, false),
    OPEN_SEARCH_DEFAULT_ACTION(
            "opensearch.default.action",
            t("bow.config.opensearch.default.action.description"),
            "w", String.class, false, false),
    OPEN_SEARCH_PREFIX_SEPARATOR(
            "opensearch.prefix.separator",
            t("bow.config.opensearch.prefix.separator.description"),
            ":", String.class, false, false),
    OPEN_SEARCH_DEFAULT_PREFIX(
            "opensearch.default.prefix",
            t("bow.config.opensearch.default.prefix.description"),
            "t", String.class, false, false),
    OPEN_SEARCH_TAG_SEARCH_PREFIX(
            "opensearch.tag.search.prefix",
            t("bow.config.opensearch.tag.search.prefix.description"),
            "t", String.class, false, false),
    OPEN_SEARCH_FULLTEXT_SEARCH_PREFIX(
            "opensearch.fulltext.search.prefix",
            t("bow.config.opensearch.fulltext.search.prefix.description"),
            "f", String.class, false, false),
    OPEN_SEARCH_WEB_SEARCH_PREFIX(
            "opensearch.web.search.prefix",
            t("bow.config.opensearch.web.search.prefix.description"),
            "w", String.class, false, false),
    OPEN_SEARCH_ALIAS_PREFIX(
            "opensearch.alias.prefix",
            t("bow.config.opensearch.alias.prefix.description"),
            "a", String.class, false, false),
    OPEN_SEARCH_ADD_PREFIX(
            "opensearch.add.prefix",
            t("bow.config.opensearch.add.prefix.description"),
            "s", String.class, false, false);

    public String key;

    public String description;

    public String defaultValue;

    public Class<?> type;

    public boolean isTransient;

    public boolean isFinal;

    BowConfigOption(String key, String description, String defaultValue,
                    Class<?> type, boolean isTransient, boolean isFinal) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isFinal = isFinal;
        this.isTransient = isTransient;
    }

    @Override
    public boolean isFinal() {
        return isFinal;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    @Override
    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }
}
