/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.preference;

import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowImport;
import org.chorem.bow.BowUser;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowProxy;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;


/**
 * Supprime un import de bookmark
 *
 * @author poussin
 */
public class DeleteImportAction extends PreferenceBaseAction {
    private static final long serialVersionUID = 8714394293884265516L;

    static private Log log = LogFactory.getLog(DeleteImportAction.class);
    
    protected String date;

    /** @return the date */
    public String getDate() {
        return date;
    }

    /** @param date the date to set */
    public void setDate(String date) {
        this.date = date;
    }

    /** Deletes a bookmark import */
    public String execute() {
        String result = SUCCESS;
        try {
            if (date != null &&
                // XXX poussin 20110818 y'a-t-il vraiment une utilite a checker
                // que la date verifie le pattern ?
                // car on pire on ne retrouve rien et donc on ne supprime rien
                date.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{1,3}Z")) {
                BowProxy proxy = getBowProxy();
                BowUser user = getBowSession().getUser();
                WikittyQuery criteria = new WikittyQueryMaker().and()
                        .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, user.getWikittyId())
                        .eq(BowImport.FQ_FIELD_BOWIMPORT_IMPORTDATE, date).end();
                List<BowImport> bookmarks = proxy.findAllByQuery(BowImport.class, criteria).getAll();

                if (log.isDebugEnabled()) {
                    log.debug("Will delete " + bookmarks.size() + " bookmarks");
                }

                proxy.delete(bookmarks);

                addActionMessage(_("bow.bookmark.import.delete.successful"));
            }
        } catch (Exception e) {
            result = ERROR;
            addActionError(_("bow.error.internal"));
            log.error(e.getMessage(), e);
        } finally {
            // on recharge les data apres l'action pour l'affichage
            load();
        }
        return result;
    }

}
