package org.chorem.bow.action.opensearch;

/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;

/**
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public class SuggestionAction extends BowBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(SuggestionAction.class);
    private static final long serialVersionUID = 1L;

    /** [in] le token d'identification */
    protected String token;
    /** [in] la requete pour lequel il faut trouver des suggesions */
    protected String q;
    /** [out] le resultat de la suggestion **/
    protected transient InputStream inputStream;

    public void setToken(String token) {
        this.token = token;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public String getQ() {
        return q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public String tag() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Start opensearch tag suggest for '%s'", q));
        }

        // preparation de la reponse. Un toString sur une liste retourne
        // la bonne syntaxe pour une reponse json :) si on triche un peu
        // en ajoutant des '' pour les chaines
        List<Object> json = new ArrayList<Object>();
        List<String> completions = new ArrayList<String>();
//        List<String> descriptions = new ArrayList<String>();
//        List<String> queryUrls = new ArrayList<String>();

        json.add("'" + q + "'");
        json.add(completions);
//        json.add(descriptions);
//        json.add(queryUrls);

        if (q != null) {
            BowUser user = getBowSession().getUser();
            BowProxy proxy = getBowProxy();

            // on ajoute * a la fin du dernier tag, car il n'est peut-etre pas fini
            String searchLineStar = q + "*";

            // on recupere le dernier tag en train d'etre ecrit
            String firstTag;
            String lastTag;
            if (q.contains(" ")) {
                firstTag = StringUtils.substringBeforeLast(q, " ") + " ";
                lastTag = StringUtils.substringAfterLast(q, " ");
            } else {
                firstTag = "";
                lastTag = q;
            }

            Set<String> searchLineList = BowUtils.getWords(searchLineStar);

            WikittyQueryMaker search = BookmarkUtils.addEqUser(new WikittyQueryMaker().and(), user.getWikittyId());
            search.exteq(BowBookmark.EXT_WIKITTYLABEL);
            search.containsAll(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS, searchLineList);

            WikittyQuery criteria = search.end()
                    .setLimit(0) // on ne veut aucun resultat, c'est la facet dont on a besoin
                    .setFacetMinCount(1) // on demande meme les labels avec 1 seul item
                    .setFacetLimit(Integer.MAX_VALUE) // ne ne met pas -1 pour qu'il soit trie par ordre de count
                    .addFacetField(BowBookmark.ELEMENT_FIELD_WIKITTYLABEL_LABELS);

            WikittyQueryResult<Wikitty> result = proxy.findAllByQuery(Wikitty.class, criteria);
            // lorsqu'on demande tout (facetLimit(-1)), les topics sont trie
            // alphabetiquement pas besoin de les retrier
            List<FacetTopic> topics = result.getTopic(BowBookmark.ELEMENT_FIELD_WIKITTYLABEL_LABELS);
            if (log.isTraceEnabled()) {
                log.trace("all topics: %s" + topics);
            }

            // on en retourne un suggestion que le meme nombre de tag qu'il souhaite
            // voir affiche
            int count = user.getTags();
            for (FacetTopic t : topics) {
                // on ne met que les topics qui qui commence par lastTag
                String completion = t.getTopicName();
                if (log.isTraceEnabled()) {
                    log.trace(String.format("'%s' startsWith '%s' ? ", completion, lastTag));
                }
                if (completion.startsWith(lastTag)) {
//                    String description = _("bow.opensearch.result", t.getCount());
//                    String tags = q + StringUtils.removeStart(completion, lastTag);
//                    String queryUrl = BowConfig.getBowUrl() + BowUtils.redirectTo(tags, null);

                    completions.add("'" + firstTag + completion + "'");
//                    descriptions.add("'" + description + "'");
//                    queryUrls.add("'" + queryUrl + "'");

                    // on s'arrete si l'on en a assez
                    count--;
                    if (count <= 0) {
                        break;
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("opensearch suggest result: %s", json));
        }
        inputStream = new ReaderInputStream(new StringReader(json.toString()));
        return SUCCESS;

    }

    public String fulltext() {
        String result = String.format("['%s', []]", q);
        inputStream = new ReaderInputStream(new StringReader(result));
        return SUCCESS;
    }

    public String alias() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Start opensearch alias suggest for '%s'", q));
        }

        // preparation de la reponse. Un toString sur une liste retourne
        // la bonne syntaxe pour une reponse json :) si on triche un peu
        // en ajoutant des '' pour les chaines
        List<Object> json = new ArrayList<Object>();
        List<String> completions = new ArrayList<String>();
//        List<String> descriptions = new ArrayList<String>();
//        List<String> queryUrls = new ArrayList<String>();

        json.add("'" + q + "'");
        json.add(completions);
//        json.add(descriptions);
//        json.add(queryUrls);

        if (q != null) {
            BowUser user = getBowSession().getUser();
            BowProxy proxy = getBowProxy();

            // on ajoute * a la fin, car il n'est peut-etre pas fini
            String privateAliasStar = q + "*";

            WikittyQueryMaker search = BookmarkUtils.addEqUser(new WikittyQueryMaker().and(), user.getWikittyId());
            search.or().
                    eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_PRIVATEALIAS, privateAliasStar).
                    eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_PUBLICALIAS, privateAliasStar);

            WikittyQuery criteria = search.end()
                    .setLimit(15); // on recupere que les 15 premiers resultats

            WikittyQueryResult<BowBookmark> result = proxy.findAllByQuery(BowBookmark.class, criteria);

            for (BowBookmark b : result) {
                String completion = b.getPrivateAlias();
//                String description = b.getDescription();
//                String queryUrl = String.format("%s%s?token=%s",
//                                                BowConfig.getAliasUrl(), completion, token);
                completions.add("'" + completion + "'");
//                descriptions.add("'" + description + "'");
//                queryUrls.add("'" + queryUrl + "'");
            }

        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("opensearch alias suggest result: %s", json));
        }
        inputStream = new ReaderInputStream(new StringReader(json.toString()));
        return SUCCESS;
    }

}
