/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.opensearch;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.chorem.bow.BowConfig;

import javax.servlet.http.HttpServletResponse;
import org.chorem.bow.BowSearchPrefix;
import org.nuiton.util.ApplicationConfig;

/**
 * Traite toutes les demandes faite via l'opensearch
 * a:, :, t:, ...
 *
 * @author poussin
 */
public class OpenSearchResultAction extends OpenSearchBaseAction implements ServletResponseAware {
    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log =
            LogFactory.getLog(OpenSearchResultAction.class);

    private static final long serialVersionUID = 1L;

    protected String redirectTo;

    protected transient HttpServletResponse response;

    /** @return the redirectTo */
    public String getRedirectTo() {
        return redirectTo;
    }

    @Override
    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    protected String executePrefixAction(BowSearchPrefix foundPrefix, String query) {
        String action;

        ApplicationConfig config = BowConfig.getConfig();

        if (foundPrefix == null) {
            action = BowConfig.getSearchEngine();
        } else {
            action = foundPrefix.getSearch();
        }

        // des alias peuvent exister dans la configuration
        String optionkey = "bow.prefix." + action;
        if (config.hasOption(optionkey)) {
            action = config.getOption(optionkey);
        }

        action = action.replace("{searchTerms}", query);
        action = response.encodeRedirectURL(action);
        redirectTo = action;

        return SUCCESS;
    }
}
