package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class BowSearchPrefixAbstract extends BusinessEntityImpl implements BowSearchPrefix {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionBowSearchPrefix;

    private static final long serialVersionUID = 7076903450171618659L;

    @Override
    public String getPrefix() {
String value = BowSearchPrefixHelper.getPrefix(getWikitty());
return value;
}

    @Override
    public void setPrefix(String prefix) {
String oldValue = getPrefix();
BowSearchPrefixHelper.setPrefix(getWikitty(), prefix);
getPropertyChangeSupport().firePropertyChange(BowSearchPrefix.FIELD_BOWSEARCHPREFIX_PREFIX, oldValue, getPrefix());
}

    @Override
    public String getSearch() {
String value = BowSearchPrefixHelper.getSearch(getWikitty());
return value;
}

    @Override
    public void setSearch(String search) {
String oldValue = getSearch();
BowSearchPrefixHelper.setSearch(getWikitty(), search);
getPropertyChangeSupport().firePropertyChange(BowSearchPrefix.FIELD_BOWSEARCHPREFIX_SEARCH, oldValue, getSearch());
}

    @Override
    public String getSuggestion() {
String value = BowSearchPrefixHelper.getSuggestion(getWikitty());
return value;
}

    @Override
    public void setSuggestion(String suggestion) {
String oldValue = getSuggestion();
BowSearchPrefixHelper.setSuggestion(getWikitty(), suggestion);
getPropertyChangeSupport().firePropertyChange(BowSearchPrefix.FIELD_BOWSEARCHPREFIX_SUGGESTION, oldValue, getSuggestion());
}

    @Override
    public String getBowUser() {
String value = BowSearchPrefixHelper.getBowUser(getWikitty());
return value;
}

    @Override
    public void setBowUser(String bowUser) {
String oldValue = getBowUser();
BowSearchPrefixHelper.setBowUser(getWikitty(), bowUser);
getPropertyChangeSupport().firePropertyChange(BowSearchPrefix.FIELD_BOWSEARCHPREFIX_BOWUSER, oldValue, getBowUser());
}

    @Override
    public BowUser getBowUser(boolean exceptionIfNotLoaded) {
BowUser value = BowSearchPrefixHelper.getBowUser(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setBowUser(BowUser bowUser) {
BowUser oldValue = getBowUser(false);
BowSearchPrefixHelper.setBowUser(getWikitty(), bowUser);
getPropertyChangeSupport().firePropertyChange(BowSearchPrefix.FIELD_BOWSEARCHPREFIX_BOWUSER, oldValue, getBowUser());
}

    public BowSearchPrefixAbstract() {
        super();
}

    public BowSearchPrefixAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public BowSearchPrefixAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionBowSearchPrefix = new WikittyExtension(EXT_BOWSEARCHPREFIX,
                "1.0", // version
                WikittyUtil.tagValuesToMap(""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String prefix fieldIndex=\"1\"", 
                                             "String search fieldIndex=\"2\"", 
                                             "String suggestion fieldIndex=\"3\"", 
                                             "Wikitty bowUser allowed=\"BowUser\" fieldIndex=\"4\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionBowSearchPrefix);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return BowSearchPrefixHelper.toString(getWikitty());
}

} //BowSearchPrefixAbstract
