package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisation;
import org.nuiton.wikitty.entities.WikittyAuthorisationHelper;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class BowImportAbstract extends BusinessEntityImpl implements BowImport {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionBowImport;

    private static final long serialVersionUID = 4050760696252162357L;

    @Override
    public Date getImportDate() {
Date value = BowImportHelper.getImportDate(getWikitty());
return value;
}

    @Override
    public void setImportDate(Date importDate) {
Date oldValue = getImportDate();
BowImportHelper.setImportDate(getWikitty(), importDate);
getPropertyChangeSupport().firePropertyChange(BowImport.FIELD_BOWIMPORT_IMPORTDATE, oldValue, getImportDate());
}

    @Override
    public Set<String> getLabels() {
Set<String> result = WikittyLabelHelper.getLabels(getWikitty());
return result;
}

    @Override
    public void setLabels(Set<String> labels) {
Set<String> oldValue = getLabels();
WikittyLabelHelper.setLabels(getWikitty(), labels);
getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    @Override
    public void addAllLabels(Collection<String> labels) {
Set<String> oldValue = getLabels();
WikittyLabelHelper.addAllLabels(getWikitty(), labels);
getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    @Override
    public void addLabels(String... element) {
Set<String> oldValue = getLabels();
WikittyLabelHelper.addLabels(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    @Override
    public void removeLabels(String... element) {
Set<String> oldValue = getLabels();
WikittyLabelHelper.removeLabels(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    @Override
    public void clearLabels() {
WikittyLabelHelper.clearLabels(getWikitty());
getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    @Override
    public String getOwner() {
String value = WikittyAuthorisationHelper.getOwner(getWikitty());
return value;
}

    @Override
    public void setOwner(String owner) {
String oldValue = getOwner();
WikittyAuthorisationHelper.setOwner(getWikitty(), owner);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, oldValue, getOwner());
}

    @Override
    public WikittyUser getOwner(boolean exceptionIfNotLoaded) {
WikittyUser value = WikittyAuthorisationHelper.getOwner(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setOwner(WikittyUser owner) {
WikittyUser oldValue = getOwner(false);
WikittyAuthorisationHelper.setOwner(getWikitty(), owner);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, oldValue, getOwner());
}

    @Override
    public Set<String> getAdmin() {
Set<String> result = WikittyAuthorisationHelper.getAdmin(getWikitty());
return result;
}

    @Override
    public void setAdmin(Set<String> admin) {
Set<String> oldValue = getAdmin();
WikittyAuthorisationHelper.setAdmin(getWikitty(), admin);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public void addAllAdmin(Collection<String> admin) {
Set<String> oldValue = getAdmin();
WikittyAuthorisationHelper.addAllAdmin(getWikitty(), admin);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public void addAdmin(String... element) {
Set<String> oldValue = getAdmin();
WikittyAuthorisationHelper.addAdmin(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public void removeAdmin(String... element) {
Set<String> oldValue = getAdmin();
WikittyAuthorisationHelper.removeAdmin(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public void clearAdmin() {
WikittyAuthorisationHelper.clearAdmin(getWikitty());
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
}

    @Override
    public Set<WikittyUser> getAdmin(boolean exceptionIfNotLoaded) {
Set<WikittyUser> result = WikittyAuthorisationHelper.getAdmin(getWikitty(), exceptionIfNotLoaded);
return result;
}

    @Override
    public void setAdminEntity(Collection<WikittyUser> admin) {
Set<WikittyUser> oldValue = getAdmin(false);
WikittyAuthorisationHelper.setAdminEntity(getWikitty(), admin);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public void addAllAdminEntity(Collection<WikittyUser> admin) {
Set<WikittyUser> oldValue = getAdmin(false);
WikittyAuthorisationHelper.addAllAdminEntity(getWikitty(), admin);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public void addAdmin(WikittyUser... element) {
Set<WikittyUser> oldValue = getAdmin(false);
WikittyAuthorisationHelper.addAdmin(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public void removeAdmin(WikittyUser... element) {
Set<WikittyUser> oldValue = getAdmin(false);
WikittyAuthorisationHelper.removeAdmin(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, oldValue, getAdmin());
}

    @Override
    public Set<String> getWriter() {
Set<String> result = WikittyAuthorisationHelper.getWriter(getWikitty());
return result;
}

    @Override
    public void setWriter(Set<String> writer) {
Set<String> oldValue = getWriter();
WikittyAuthorisationHelper.setWriter(getWikitty(), writer);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public void addAllWriter(Collection<String> writer) {
Set<String> oldValue = getWriter();
WikittyAuthorisationHelper.addAllWriter(getWikitty(), writer);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public void addWriter(String... element) {
Set<String> oldValue = getWriter();
WikittyAuthorisationHelper.addWriter(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public void removeWriter(String... element) {
Set<String> oldValue = getWriter();
WikittyAuthorisationHelper.removeWriter(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public void clearWriter() {
WikittyAuthorisationHelper.clearWriter(getWikitty());
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
}

    @Override
    public Set<WikittyUser> getWriter(boolean exceptionIfNotLoaded) {
Set<WikittyUser> result = WikittyAuthorisationHelper.getWriter(getWikitty(), exceptionIfNotLoaded);
return result;
}

    @Override
    public void setWriterEntity(Collection<WikittyUser> writer) {
Set<WikittyUser> oldValue = getWriter(false);
WikittyAuthorisationHelper.setWriterEntity(getWikitty(), writer);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public void addAllWriterEntity(Collection<WikittyUser> writer) {
Set<WikittyUser> oldValue = getWriter(false);
WikittyAuthorisationHelper.addAllWriterEntity(getWikitty(), writer);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public void addWriter(WikittyUser... element) {
Set<WikittyUser> oldValue = getWriter(false);
WikittyAuthorisationHelper.addWriter(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public void removeWriter(WikittyUser... element) {
Set<WikittyUser> oldValue = getWriter(false);
WikittyAuthorisationHelper.removeWriter(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, oldValue, getWriter());
}

    @Override
    public Set<String> getReader() {
Set<String> result = WikittyAuthorisationHelper.getReader(getWikitty());
return result;
}

    @Override
    public void setReader(Set<String> reader) {
Set<String> oldValue = getReader();
WikittyAuthorisationHelper.setReader(getWikitty(), reader);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public void addAllReader(Collection<String> reader) {
Set<String> oldValue = getReader();
WikittyAuthorisationHelper.addAllReader(getWikitty(), reader);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public void addReader(String... element) {
Set<String> oldValue = getReader();
WikittyAuthorisationHelper.addReader(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public void removeReader(String... element) {
Set<String> oldValue = getReader();
WikittyAuthorisationHelper.removeReader(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public void clearReader() {
WikittyAuthorisationHelper.clearReader(getWikitty());
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
}

    @Override
    public Set<WikittyUser> getReader(boolean exceptionIfNotLoaded) {
Set<WikittyUser> result = WikittyAuthorisationHelper.getReader(getWikitty(), exceptionIfNotLoaded);
return result;
}

    @Override
    public void setReaderEntity(Collection<WikittyUser> reader) {
Set<WikittyUser> oldValue = getReader(false);
WikittyAuthorisationHelper.setReaderEntity(getWikitty(), reader);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public void addAllReaderEntity(Collection<WikittyUser> reader) {
Set<WikittyUser> oldValue = getReader(false);
WikittyAuthorisationHelper.addAllReaderEntity(getWikitty(), reader);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public void addReader(WikittyUser... element) {
Set<WikittyUser> oldValue = getReader(false);
WikittyAuthorisationHelper.addReader(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public void removeReader(WikittyUser... element) {
Set<WikittyUser> oldValue = getReader(false);
WikittyAuthorisationHelper.removeReader(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, oldValue, getReader());
}

    @Override
    public String getParent() {
String value = WikittyAuthorisationHelper.getParent(getWikitty());
return value;
}

    @Override
    public void setParent(String parent) {
String oldValue = getParent();
WikittyAuthorisationHelper.setParent(getWikitty(), parent);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, oldValue, getParent());
}

    @Override
    public WikittyAuthorisation getParent(boolean exceptionIfNotLoaded) {
WikittyAuthorisation value = WikittyAuthorisationHelper.getParent(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setParent(WikittyAuthorisation parent) {
WikittyAuthorisation oldValue = getParent(false);
WikittyAuthorisationHelper.setParent(getWikitty(), parent);
getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, oldValue, getParent());
}

    @Override
    public String getLink() {
String value = BowBookmarkHelper.getLink(getWikitty());
return value;
}

    @Override
    public void setLink(String link) {
String oldValue = getLink();
BowBookmarkHelper.setLink(getWikitty(), link);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_LINK, oldValue, getLink());
}

    @Override
    public String getDescription() {
String value = BowBookmarkHelper.getDescription(getWikitty());
return value;
}

    @Override
    public void setDescription(String description) {
String oldValue = getDescription();
BowBookmarkHelper.setDescription(getWikitty(), description);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION, oldValue, getDescription());
}

    @Override
    public Date getCreationDate() {
Date value = BowBookmarkHelper.getCreationDate(getWikitty());
return value;
}

    @Override
    public void setCreationDate(Date creationDate) {
Date oldValue = getCreationDate();
BowBookmarkHelper.setCreationDate(getWikitty(), creationDate);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE, oldValue, getCreationDate());
}

    @Override
    public int getClick() {
int value = BowBookmarkHelper.getClick(getWikitty());
return value;
}

    @Override
    public void setClick(int click) {
int oldValue = getClick();
BowBookmarkHelper.setClick(getWikitty(), click);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_CLICK, oldValue, getClick());
}

    @Override
    public String getPrivateAlias() {
String value = BowBookmarkHelper.getPrivateAlias(getWikitty());
return value;
}

    @Override
    public void setPrivateAlias(String privateAlias) {
String oldValue = getPrivateAlias();
BowBookmarkHelper.setPrivateAlias(getWikitty(), privateAlias);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS, oldValue, getPrivateAlias());
}

    @Override
    public String getPublicAlias() {
String value = BowBookmarkHelper.getPublicAlias(getWikitty());
return value;
}

    @Override
    public void setPublicAlias(String publicAlias) {
String oldValue = getPublicAlias();
BowBookmarkHelper.setPublicAlias(getWikitty(), publicAlias);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS, oldValue, getPublicAlias());
}

    @Override
    public String getAuthentificationInfo() {
String value = BowBookmarkHelper.getAuthentificationInfo(getWikitty());
return value;
}

    @Override
    public void setAuthentificationInfo(String authentificationInfo) {
String oldValue = getAuthentificationInfo();
BowBookmarkHelper.setAuthentificationInfo(getWikitty(), authentificationInfo);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO, oldValue, getAuthentificationInfo());
}

    @Override
    public byte[] getFavicon() {
byte[] value = BowBookmarkHelper.getFavicon(getWikitty());
return value;
}

    @Override
    public void setFavicon(byte[] favicon) {
byte[] oldValue = getFavicon();
BowBookmarkHelper.setFavicon(getWikitty(), favicon);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_FAVICON, oldValue, getFavicon());
}

    @Override
    public byte[] getScreenshot() {
byte[] value = BowBookmarkHelper.getScreenshot(getWikitty());
return value;
}

    @Override
    public void setScreenshot(byte[] screenshot) {
byte[] oldValue = getScreenshot();
BowBookmarkHelper.setScreenshot(getWikitty(), screenshot);
getPropertyChangeSupport().firePropertyChange(BowBookmark.FIELD_BOWBOOKMARK_SCREENSHOT, oldValue, getScreenshot());
}

    public BowImportAbstract() {
        super();
}

    public BowImportAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public BowImportAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionBowImport = new WikittyExtension(EXT_BOWIMPORT,
                "1.0", // version
                WikittyUtil.tagValuesToMap(" version=\"1.0\""), // tag/values
                BowBookmark.EXT_BOWBOOKMARK,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "Date importDate fieldIndex=\"1\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(BowBookmarkAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBowImport);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return BowImportHelper.toString(getWikitty());
}

} //BowImportAbstract
