package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class BowBookmarkHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private BowBookmarkHelper() {// empty
}

    public static String getLink(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK);
        return value;
}

    public static String setLink(Wikitty wikitty, String link) {
        String oldValue = getLink(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK, link);
        return oldValue;
}

    public static String getDescription(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION);
        return value;
}

    public static String setDescription(Wikitty wikitty, String description) {
        String oldValue = getDescription(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION, description);
        return oldValue;
}

    public static Date getCreationDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE);
        return value;
}

    public static Date setCreationDate(Wikitty wikitty, Date creationDate) {
        Date oldValue = getCreationDate(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE, creationDate);
        return oldValue;
}

    public static int getClick(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK);
        return value;
}

    public static int setClick(Wikitty wikitty, int click) {
        int oldValue = getClick(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK, click);
        return oldValue;
}

    public static String getPrivateAlias(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS);
        return value;
}

    public static String setPrivateAlias(Wikitty wikitty, String privateAlias) {
        String oldValue = getPrivateAlias(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS, privateAlias);
        return oldValue;
}

    public static String getPublicAlias(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS);
        return value;
}

    public static String setPublicAlias(Wikitty wikitty, String publicAlias) {
        String oldValue = getPublicAlias(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS, publicAlias);
        return oldValue;
}

    public static String getAuthentificationInfo(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO);
        return value;
}

    public static String setAuthentificationInfo(Wikitty wikitty, String authentificationInfo) {
        String oldValue = getAuthentificationInfo(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO, authentificationInfo);
        return oldValue;
}

    public static byte[] getFavicon(Wikitty wikitty) {
        byte[] value = wikitty.getFieldAsBytes(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_FAVICON);
        return value;
}

    public static byte[] setFavicon(Wikitty wikitty, byte[] favicon) {
        byte[] oldValue = getFavicon(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_FAVICON, favicon);
        return oldValue;
}

    public static byte[] getScreenshot(Wikitty wikitty) {
        byte[] value = wikitty.getFieldAsBytes(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_SCREENSHOT);
        return value;
}

    public static byte[] setScreenshot(Wikitty wikitty, byte[] screenshot) {
        byte[] oldValue = getScreenshot(wikitty);
        wikitty.setField(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_SCREENSHOT, screenshot);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_LINK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_CLICK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PRIVATEALIAS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_PUBLICALIAS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_AUTHENTIFICATIONINFO);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_FAVICON);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_FAVICON);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_SCREENSHOT);
            Object f2 = w2.getFieldAsObject(BowBookmark.EXT_BOWBOOKMARK, BowBookmark.FIELD_BOWBOOKMARK_SCREENSHOT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(BowBookmark.EXT_BOWBOOKMARK);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : BowBookmarkAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * supprime les extensions de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void removeExtension(Wikitty wikitty) {
        for (WikittyExtension ext : BowBookmarkAbstract.extensions) {
            wikitty.removeExtension(ext.getName());
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(BowBookmark.EXT_BOWBOOKMARK);
}

} //BowBookmarkHelper
