/*
 * #%L
 * BOW UI
 * 
 * $Id: bookmark.js 306 2011-08-18 02:37:38Z bpoussin $
 * $HeadURL: https://svn.chorem.org/bow/tags/bow-1.3/bow-ui/src/main/webapp/js/bookmark.js $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
function deleteBookmarkConfirmation(goTo, bookmarkName) {
    deleteConfirmation(goTo, bookmarkName, 0, undefined);
}

function deleteImportConfirmation(goTo, bookmarksNb, importDate) {
    deleteConfirmation(goTo, undefined, bookmarksNb, importDate);
}

function deleteConfirmation(goTo, bookmarkName, bookmarksNb, importDate) {
// TODO sletellier 20110516 : use i18n to translate this !

  var confMsg = "Do you really want to delete ";

  if (bookmarksNb > 1) {
    confMsg += "these " + bookmarksNb + " bookmarks";
  } else {
    confMsg += "bookmark:\n'" + bookmarkName + "'";
  }
           
  if (importDate !== undefined)
    confMsg += " imported the " + importDate + " ?";
  else
    confMsg += " ?";
  if (confirm(confMsg)) {
    window.location = goTo;
  }
  return false;
}
