<%--
#%L
bow

$Id: preferences.jsp 368 2013-09-26 18:18:46Z bpoussin $
$HeadURL: https://svn.chorem.org/bow/tags/bow-1.3/bow-ui/src/main/webapp/WEB-INF/jsp/preferences.jsp $
%%
Copyright (C) 2010 CodeLutin
%%
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
#L%
--%>
<%@page import="org.chorem.bow.action.preference.PreferenceBaseAction"%>
<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@taglib prefix="s" uri="/struts-tags" %>

<html xmlns:s="http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd"
      xmlns:jsp="http://java.sun.com/JSP/Page">
<head>
    <title><s:text name="bow.preferences.title"/></title>
    <s:url var="css" value="/css/bookmark.css"/>
    <link href="${css}" rel="stylesheet" type="text/css"/>
    <s:head/>
</head>
<body>
<div id="content">
    <div class="menu clearfix">
        <h2><s:text name="bow.preferences.title"/></h2>
    </div>
    <s:actionerror/>

    <div class="formFrame fond">
        <s:set var="permanentToken" value="bowSession.getPermanentToken()" />
        <s:set var="temporaryToken" value="bowSession.getTemporaryToken()" />
        <ul>
            <li>
                <s:a title="%{getText('bow.temporary.link.searchDescription')}"
                   href="openSearchResult.action?token=%{temporaryToken}&amp;q={searchTerms}">
                    <s:text name="bow.temporary.link.search" />
                </s:a>
            </li>
            <li>
                <s:a title="%{getText('bow.permanent.link.searchDescription')}"
                   href="openSearchResult.action?token=%{permanentToken}&amp;q={searchTerms}">
                    <s:text name="bow.permanent.link.search" />
                </s:a>
            </li>
            <li>
                <s:a title="%{getText('bow.temporary.link.suggestionDescription')}"
                   href="openSearchSuggestion.action?token=%{temporaryToken}&amp;q={searchTerms}">
                    <s:text name="bow.temporary.link.suggestion" />
                </s:a>
            </li>
            <li>
                <s:a title="%{getText('bow.permanent.link.suggestionDescription')}"
                   href="openSearchSuggestion.action?token=%{permanentToken}&amp;q={searchTerms}">
                    <s:text name="bow.permanent.link.suggestion" />
                </s:a>
            </li>
            <li>
                <s:a title="%{getText('bow.rightMenu.bookmark.temporaryLinkDescription')}"
                   href="javascript:var%20url=location.href;var%20nameAndTags=prompt('Entrez%20le%20nom%20du%20lien%20et%20la%20liste%20des%20tags%20sous%20la%20forme:%20name|tag1%20tag2%20tag3',%20document.title+'|');var%20link='%{config.bowUrl}addUrl.action?token=%{temporaryToken}&amp;link='+encodeURIComponent(url)+'&amp;nameAndTags='+encodeURIComponent(nameAndTags);var%20script=document.createElement('script');script.src=link;script.type='text/javascript';document.body.appendChild(script);void(0);">
                    <s:text name="bow.rightMenu.bookmark.temporaryLink" />
                </s:a>
            </li>
            <li>
                <s:a title="%{getText('bow.rightMenu.bookmark.permanentLinkDescription')}"
                   href="javascript:var%20url=location.href;var%20nameAndTags=prompt('Entrez%20le%20nom%20du%20lien%20et%20la%20liste%20des%20tags%20sous%20la%20forme:%20name|tag1%20tag2%20tag3',%20document.title+'|');var%20link='%{config.bowUrl}addUrl.action?token=%{permanentToken}&amp;link='+encodeURIComponent(url)+'&amp;nameAndTags='+encodeURIComponent(nameAndTags);var%20script=document.createElement('script');script.src=link;script.type='text/javascript';document.body.appendChild(script);void(0);">
                    <s:text name="bow.rightMenu.bookmark.permanentLink" />
                </s:a>
            </li>
            <li>
                <a href="extensions/bow4chromium.crx">
                    <img src="img/chromium.png" alt="Chromium" class="extensionIcon" />
                    <s:text name="bow.rightMenu.chromiumExtension" />
                </a>
            </li>
            <li>
                <strong><s:text name="bow.rightMenu.token.permanent"/> :</strong>
                <s:property value="%{#permanentToken}"/>
            </li>
            <li>
                <strong><s:text name="bow.rightMenu.token.temporary"/> :</strong>
                <s:property value="%{#temporaryToken}"/>
            </li>
        </ul>

        <s:url var="regenPermToken" action="generateToken"/>
        <s:a href="%{regenPermToken}" id="regenPermToken">
            <s:text name="bow.preferences.regenPermToken"/>
        </s:a>
    </div>

    <div class="formFrame fond">
        <h3><s:text name="bow.preferences.userInfo"/></h3>
        <br/>
        <s:form action="updateUserPref" theme="simple">
            <s:text name="bow.login.email"/><br/>
            <s:textfield name="email"
                         labelposition="top"/><br/>

            <s:text name="bow.preferences.currentPassword"/><br/>
            <s:password name="currentPassword"
                        labelposition="top"/><br/>

            <s:text name="bow.preferences.newPassword"/><br/>
            <s:password name="newPassword"
                        labelposition="top"/><br/>

            <s:text name="bow.preferences.confirmNewPassword"/><br/>
            <s:password name="confirmNewPassword"
                        labelposition="top"/><br/>
            <s:hidden name="update" value="user"/>
            <s:submit key="bow.preferences.submit" name="submit"/>
        </s:form>
    </div>
    <div class="formFrame fond">
        <h3><s:text name="bow.preferences.siteLook"/></h3>
        <br/>

        <script type="text/javascript">
            function setRemoveIndex(removeIndex) {
                $('input[name="removedPrefix"]').val(removeIndex);
                document.updateSitePref.submit();
                return false;
            }
        </script>

        <s:form name="updateSitePref" action="updateSitePref" theme="simple">
            <s:hidden name="removedPrefix" value="-1"/>

            <s:text name="bow.preferences.screenshot"/><br/>
            <s:checkbox name="screenshot" labelposition="left"/><br/>

            <s:text name="bow.preferences.favicon"/><br/>
            <s:checkbox name="favicon" labelposition="left"/><br/>

            <s:text name="bow.preferences.tagsNb"/><br/>
            <s:textfield name="tagsNb" labelposition="top"/><br/>

            <s:text name="bow.preferences.bookmarksHomePage"/><br/>
            <s:textfield name="bookmarksHomePage" labelposition="top"/><br/>

            <table>
                <tr>
                    <th><s:text name="bow.preferences.opensearch.prefix"/></th>
                    <th><s:text name="bow.preferences.opensearch.value"/></th>
                    <th><s:text name="bow.preferences.searchEngineUrlSuggestions"/></th>
                </tr>

            <s:iterator value="searchPrefix" status="stat">
                <tr>
                    <td><s:textfield name="searchPrefix[%{#stat.index}].prefix" value="%{prefix}"/></td>
                    <td><s:textfield name="searchPrefix[%{#stat.index}].search" value="%{search}"/></td>
                    <td><s:textfield name="searchPrefix[%{#stat.index}].suggestion" value="%{suggestion}"/></td>
                    <td><s:submit action="removePrefix" value="X" onclick="return setRemoveIndex(%{#stat.index})"></s:submit></td>
                </tr>
            </s:iterator>
            </table>
            <s:submit action="addPrefix" value="add prefix"></s:submit>

            <s:hidden name="update" value="site"/>
            <s:submit key="bow.preferences.submit" name="submit"/>
        </s:form>
    </div>

    <div class="menu clearfix">
        <h2><s:text name="bow.preferences.tagsManagement"/></h2>
    </div>

    <div class="formFrame fond">
        <h3><s:text name="bow.preferences.labels"/>(<s:property value="labels.size()"/>)</h3>
        <br/>
        <s:form id="labelsForm" action="adminlabels" method="post" theme="simple">
            <div class="list">
                <s:checkboxlist  name="selectedLabels" list="labels"
                                 listKey="topicName" listValue="%{topicName+'('+count+')'}"/>
            </div>
            <div class="action">
                <s:text name="bow.preferences.labels.name.field"/><s:textfield name="newLabel" />
                <s:submit name="rename" key="bow.preferences.labels.rename.submit" />
                <s:submit name="delete" key="bow.preferences.labels.delete.submit" />
            </div>
        </s:form>
    </div>

    <div class="menu clearfix">
        <h2><s:text name="bow.preferences.importExport"/></h2>
    </div>

    <div class="formFrame fond">
        <s:a action="exportBookmarks"><s:text name="bow.preferences.export.bookmarks"/></s:a>
        <br/>

        <h3><s:text name="bow.preferences.import.bookmarks"/></h3>
        <br/>
        <s:form action="importBookmarks" method="post" enctype="multipart/form-data" theme="simple">
            <s:file name="upfile" labelSeparator=""/>
            <s:hidden name="tagLine" value="%{tagLine}"/>
            <s:hidden name="fullTextLine" value="%{fullTextLine}"/>
            <s:submit key="bow.preferences.import.submit" name="submit"/>
        </s:form>
        <br/><br/>

        <s:if test="bookmarksImportDate != null">
            <s:iterator value="bookmarksImportDate">
                <s:set name="date" value="%{key}"/>
                <s:set name="nb" value="%{value}"/>
                <s:date name="%{stringToDate(#date)}" var="dateString"/>
                <div class="deleteImport">
                    <span><s:property value="dateString"/>  (<s:property value="#nb"/> bookmarks)</span>
                    <s:url var="deleteImport" action="deleteImport">
                        <s:param name="date" value="#date"/>
                    </s:url>
                    <s:a cssClass="deleteImportButton" href="%{deleteImport}"
                       onclick="return deleteConfirmation('%{deleteImport}','%{nb}','%{dateString}');">
                    </s:a>
                </div>
            </s:iterator>
        </s:if>
        <s:else>
            <span><s:text name="bow.preferences.noImportedBookmarks"/></span>
        </s:else>
    </div>

</div>
</body>
</html>