<%--
  #%L
  bow
  
  $Id: bookmark.jsp 373 2014-03-09 23:48:24Z bpoussin $
  $HeadURL: https://svn.chorem.org/bow/tags/bow-1.3/bow-ui/src/main/webapp/WEB-INF/jsp/inc/bookmark.jsp $
  %%
  Copyright (C) 2010 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib prefix="s" uri="/struts-tags" %>
<%@taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib uri="/WEB-INF/bowutils" prefix="u" %>

<div class="bookmark"bow
     xmlns:s="http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd"
     xmlns:jsp="http://java.sun.com/JSP/Page">

        <div class="bookmarkhead">
            <span class="left">
                <s:set var="favicon" value="#bookmark.favicon"/>
                <c:if test="${fn:length(favicon) > 0}">
                    <img class="favicon" src="data:image/png;base64,${u:base64(favicon)}"/>
                </c:if>
                <c:if test="${fn:length(favicon) <= 0}">
                    <img src="img/ptit-livre.jpg"/>
                </c:if>
            </span>
            <span class="left date"><s:property value="#bookmark.creationDate"/></span>
            <span class="left">
                <s:if test="%{!#bookmark.privateAlias.empty}">
                    <s:a cssClass="alias" href="%{config.aliasUrl + #bookmark.wikittyId}.action"
                         title="%{#bookmark.link}" target="_blank">
                        a:<s:property value="%{#bookmark.privateAlias}" />
                    </s:a>
                </s:if>
            </span>
            <span class="left">
                <s:if test="%{!#bookmark.publicAlias.empty}">
                    <s:a cssClass="alias" href="%{config.aliasUrl + #bookmark.publicAlias}.action"
                         title="%{#bookmark.link}" target="_blank">
                        a:<s:property value="%{#bookmark.publicAlias}" />
                    </s:a>
                </s:if>
            </span>
            <span class="spacemax"></span>
            <span class="right">
                <s:url var="screenshotBookmark" action="screenshotBookmark" escapeAmp="true">
                    <s:param name="id" value="%{#bookmark.wikittyId}" />
                    <s:param name="tagLine" value="%{tagLine}" />
                    <s:param name="fullTextLine" value="%{fullTextLine}" />
                    <s:param name="order" value="%{order}"/>
                    <s:param name="first" value="%{first}"/>
                </s:url>
                <s:a cssClass="screenshotLink" href="%{screenshotBookmark}"/>
            </span>
            <span class="right">
                <s:url var="editBookmark" action="editBookmark" escapeAmp="true">
                    <s:param name="id" value="%{#bookmark.wikittyId}" />
                    <s:param name="tagLine" value="%{tagLine}" />
                    <s:param name="fullTextLine" value="%{fullTextLine}" />
                    <s:param name="order" value="%{order}"/>
                    <s:param name="first" value="%{first}"/>
                </s:url>
                <s:a cssClass="edit" href="%{editBookmark}"/>
            </span>
            <span class="right">
                <s:url var="removeBookmark" action="removeBookmark" escapeAmp="true">
                    <s:param name="bookmarkId" value="%{#bookmark.wikittyId}" />
                    <s:param name="tagLine" value="%{tagLine}" />
                    <s:param name="fullTextLine" value="%{fullTextLine}" />
                    <s:param name="order" value="%{order}"/>
                    <s:param name="first" value="%{first}"/>
                </s:url>
                <s:a cssClass="supprim" href="%{removeBookmark}"
                     onclick="return deleteConfirmation('%{#removeBookmark}','%{#bookmark.link}');"></s:a>
            </span>
        </div>

        <div class="bookmarkcontenu">
            <s:a title="%{#bookmark.link}" href="alias/%{#bookmark.wikittyId}.action" target="_blank">
                <div class="screenshot">
                    <s:set var="screenshot" value="#bookmark.screenshot"/>
                    <c:if test="${fn:length(screenshot) > 0}">
                        <img src="data:image/png;base64,${u:base64(screenshot)}"/>
                    </c:if>
                    <c:if test="${fn:length(screenshot) <= 0}">
                        <img src="img/livreG.jpg"/>
                    </c:if>
                </div>
            </s:a>
            <div class="click"><s:property value="%{#bookmark.click}" /></div>
            <div class="description">
                <p>
                    <s:a href="alias/%{#bookmark.wikittyId}.action"><s:property value="%{#bookmark.link}"/></s:a>
                </p>
                <h3><s:text name="bow.bookmark.description" /> :</h3>
                <p>
                    <s:property value="%{#bookmark.description}"/>
                </p>
                <p class="tags">
                    <strong><s:text name="bow.bookmark.tags" /> :</strong>
                    <s:iterator value="#bookmark.labels" var="tag">
                        <s:url var="search" action="home">
                            <s:param name="addTag" value="%{#tag}"/>
                            <s:param name="tagLine" value="%{tagLine}"/>
                            <s:param name="fullTextLine" value="%{fullTextLine}"/>
                            <s:param name="order" value="%{order}"/>
                            <%-- on ne met pas 'first', il faut repartir de 0 --%>
                        </s:url>
                        <s:a href="%{search}" cssClass="tag"><s:property value="%{#tag}"/></s:a>
                    </s:iterator>
                </p>
            </div>
        </div>

</div>
