/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.preference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.preference.PreferenceBaseAction;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;

public class AdminTagAction
extends PreferenceBaseAction {
    private static final Log log = LogFactory.getLog(AdminTagAction.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        String result = "success";
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Selected labels: " + Arrays.toString(this.selectedLabels)));
                log.debug((Object)("action delete: " + this.delete + " rename: " + this.rename));
            }
            List<String> selectedLabelsList = Arrays.asList(this.selectedLabels);
            boolean isRename = StringUtils.isNotEmpty((CharSequence)this.rename);
            BowProxy proxy = this.getBowProxy();
            BowUser user = this.getBowSession().getUser();
            String userId = user.getWikittyId();
            WikittyQuery c = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).containsOne("WikittyLabel.labels", selectedLabelsList)).eq("WikittyAuthorisation.owner", (Object)userId)).end();
            WikittyQueryResult searchResult = proxy.findAllByQuery(WikittyLabel.class, c);
            ArrayList<WikittyLabel> toStore = new ArrayList<WikittyLabel>();
            for (WikittyLabel label : searchResult) {
                toStore.add(label);
                HashSet<String> l = label.getLabels();
                if (l == null) continue;
                l = new HashSet<String>(l);
                l.removeAll(selectedLabelsList);
                if (isRename) {
                    l.add(this.newLabel);
                }
                label.setLabels(l);
            }
            proxy.store(toStore);
        }
        catch (Exception eee) {
            this.addActionError(this._("bow.error.internal"));
            log.error((Object)eee.getMessage(), (Throwable)eee);
        }
        finally {
            this.load(new PreferenceBaseAction.PreferenceType[0]);
        }
        return result;
    }
}

