/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.login;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowMail;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUserImpl;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

public class RegisterAction
extends BowBaseAction {
    private static final long serialVersionUID = 2204772861770399542L;
    private static Log log = LogFactory.getLog(RegisterAction.class);
    protected String email;
    protected String password;
    protected String repeatPassword;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRepeatPassword() {
        return this.repeatPassword;
    }

    public void setRepeatPassword(String repeatPassword) {
        this.repeatPassword = repeatPassword;
    }

    protected boolean alreadyRegistered(String email) {
        WikittyQuery criteria;
        boolean result;
        BowProxy proxy = this.getBowProxy();
        boolean bl = result = proxy.findByQuery(BowUser.class, criteria = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyUser.login", (Object)email)).end()) != null;
        if (result) {
            this.addFieldError("email", this._("bow.register.emailAldyUsed"));
        }
        return result;
    }

    public String execute() {
        String result;
        block7: {
            result = "input";
            try {
                if (!StringUtils.isNotBlank((CharSequence)this.email)) break block7;
                this.email = this.email.trim();
                if (!StringUtils.isNotBlank((CharSequence)this.password)) break block7;
                if (!this.password.equals(this.repeatPassword)) {
                    this.addActionError(this._("bow.register.pwdDontMatch"));
                    break block7;
                }
                String md5 = StringUtil.encodeMD5((String)this.password);
                if (this.alreadyRegistered(this.email)) break block7;
                BowProxy proxy = this.getBowProxy();
                BowUserImpl newUser = new BowUserImpl();
                newUser.setPassword(md5);
                newUser.setLogin(this.email);
                String permanentToken = BowUtils.generateToken();
                newUser.setPermanentToken(permanentToken);
                BowUser login = (BowUser)proxy.store((BusinessEntity)newUser);
                if (login == null) {
                    this.addFieldError("email", this._("bow.register.invalidLogin"));
                    break block7;
                }
                this.getBowSession().setUser(login);
                try {
                    String mailContent = this._("bow.register.mailHi") + ",\n\n" + this._("bow.register.mailPwd") + ": " + this.password + "\n\n" + this._("bow.register.mailEmail") + ": " + this.email + "\n\n";
                    BowMail.sendMail((String)this.email, (String)this._("bow.register.mailSubject"), (String)mailContent);
                }
                catch (AddressException eee) {
                    this.addActionError(this._("bow.mail.badFormat"));
                    log.error((Object)String.format("Can't send message email to '%s'", this.email), (Throwable)eee);
                }
                catch (MessagingException eee) {
                    this.addActionError("bow.mail.sendError");
                    log.error((Object)String.format("Can't send message email to '%s'", this.email), (Throwable)eee);
                }
                result = "success";
            }
            catch (Exception eee) {
                this.addActionError(this._("bow.error.internal"));
                log.error((Object)eee.getMessage(), (Throwable)eee);
            }
        }
        return result;
    }
}

