/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.bookmark;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.BusinessEntity;

public class ScreenshotAction
extends BowBaseAction {
    private static final long serialVersionUID = 820566716695285561L;
    private static final Log log = LogFactory.getLog(ScreenshotAction.class);
    protected String id;
    protected String redirectTo;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public String execute() {
        if (StringUtils.isNotEmpty((CharSequence)this.id)) {
            try {
                BowProxy proxy = this.getBowProxy();
                BowBookmark bookmark = (BowBookmark)proxy.restore(BowBookmark.class, this.id, new String[0]);
                if (bookmark != null) {
                    byte[] favicone;
                    boolean changed = false;
                    String link = bookmark.getLink();
                    byte[] screenshot = BookmarkUtils.getScreenshot((String)link);
                    if (ArrayUtils.isNotEmpty((byte[])screenshot)) {
                        bookmark.setScreenshot(screenshot);
                        changed = true;
                        this.addActionMessage(this._("bow.bookmark.screenshot.updated.successful"));
                    }
                    if (ArrayUtils.isNotEmpty((byte[])(favicone = BookmarkUtils.getFavicon((String)link)))) {
                        bookmark.setFavicon(favicone);
                        changed = true;
                        this.addActionMessage(this._("bow.bookmark.favicon.updated.successful"));
                    }
                    if (changed) {
                        proxy.store((BusinessEntity)bookmark);
                    }
                }
            }
            catch (Exception eee) {
                this.addActionError(this._("bow.error.internal"));
                log.error((Object)"Can't do action", (Throwable)eee);
            }
        }
        this.redirectTo = BowUtils.redirectTo((String)this.tagLine, (String)this.fullTextLine);
        return "success";
    }
}

