/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowUtils;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQueryResult;

public class BowSearchResult {
    private static final Log log = LogFactory.getLog(BowSearchResult.class);
    protected int bookmarkCount;
    protected List<BowBookmark> bookmarks;
    protected List<FacetTopic> tagsCloud;
    protected int tmax = -1;
    protected int tmin = -1;

    public BowSearchResult(WikittyQueryResult<BowBookmark> result, String tagLine) {
        this.bookmarkCount = result.getTotalResult();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Find %s items, used %s", this.bookmarkCount, result.size()));
        }
        this.setBookmarks(result.getAll());
        List topics = result.getTopic("WikittyLabel.labels");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("There are %s tag in cloud", CollectionUtils.isEmpty((Collection)topics) ? 0 : topics.size()));
        }
        this.setTagCloud(topics, tagLine);
    }

    protected void setTagCloud(List<FacetTopic> cpy, String excludeTag) {
        this.tagsCloud = new ArrayList();
        if (cpy != null) {
            this.tagsCloud.addAll(cpy);
            ArrayList save = new ArrayList(this.tagsCloud);
            Set tagsSearch = BowUtils.getWords((String)excludeTag);
            Iterator i = this.tagsCloud.iterator();
            while (i.hasNext()) {
                FacetTopic topic = (FacetTopic)i.next();
                String name = topic.getTopicName();
                if (!tagsSearch.contains(name)) continue;
                i.remove();
            }
            this.tmax = -1;
            this.tmin = -1;
            for (FacetTopic tag : this.tagsCloud) {
                int value = tag.getCount();
                if (this.tmax < value) {
                    this.tmax = value;
                }
                if (this.tmin == -1) {
                    this.tmin = value;
                    continue;
                }
                if (this.tmin <= value) continue;
                this.tmin = value;
            }
        }
    }

    public int getFont(int ti) {
        int font = 1;
        if (this.tmax > this.tmin) {
            font = 30 * (ti - this.tmin) / (this.tmax - this.tmin);
        }
        if (font < 10) {
            font = 10;
        }
        return font;
    }

    public List<FacetTopic> getTagsCloud() {
        return this.tagsCloud;
    }

    public List<BowBookmark> getBookmarks() {
        return this.bookmarks;
    }

    protected void setBookmarks(List<BowBookmark> bookmarks) {
        this.bookmarks = new ArrayList();
        if (bookmarks != null) {
            this.bookmarks.addAll(bookmarks);
        }
    }

    public int getTmin() {
        return this.tmin;
    }

    public int getTmax() {
        return this.tmax;
    }

    public int getBookmarkCount() {
        return this.bookmarkCount;
    }
}

