/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowSearchPrefixImpl;
import org.nuiton.util.VersionUtil;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class BowMigrationPreference
extends WikittyExtensionMigrationRename {
    private static final Log log = LogFactory.getLog(BowMigrationPreference.class);

    protected void migrateBowPrefix(WikittyService service, Wikitty oldWikitty, Wikitty newWikitty) {
        String userId = oldWikitty.getWikittyId();
        if (userId != null) {
            String prefixSeparator = (String)oldWikitty.getFqField("BowPreference.prefixSeparator");
            String defaultAction = (String)oldWikitty.getFqField("BowPreference.defaultAction");
            String defaultPrefix = (String)oldWikitty.getFqField("BowPreference.defaultPrefix");
            String tagSearchPrefix = (String)oldWikitty.getFqField("BowPreference.tagSearchPrefix");
            String fullTextSearchPrefix = (String)oldWikitty.getFqField("BowPreference.fullTextSearchPrefix");
            String webSearchPrefix = (String)oldWikitty.getFqField("BowPreference.webSearchPrefix");
            String aliasPrefix = (String)oldWikitty.getFqField("BowPreference.aliasPrefix");
            String searchEngineUrlResults = (String)oldWikitty.getFqField("BowPreference.searchEngineUrlResults");
            String searchEngineUrlSuggestions = (String)oldWikitty.getFqField("BowPreference.searchEngineUrlSuggestions");
            BowSearchPrefixImpl pWeb = new BowSearchPrefixImpl();
            pWeb.setBowUser(userId);
            pWeb.setPrefix(webSearchPrefix + prefixSeparator);
            pWeb.setSearch(searchEngineUrlResults);
            pWeb.setSuggestion(searchEngineUrlSuggestions);
            BowSearchPrefixImpl pTag = new BowSearchPrefixImpl();
            pTag.setBowUser(userId);
            pTag.setPrefix(tagSearchPrefix + prefixSeparator);
            pTag.setSearch("search.tag");
            pTag.setSuggestion("suggestion.tag");
            BowSearchPrefixImpl pFullText = new BowSearchPrefixImpl();
            pFullText.setBowUser(userId);
            pFullText.setPrefix(fullTextSearchPrefix + prefixSeparator);
            pFullText.setSearch("search.fulltext");
            pFullText.setSuggestion("suggestion.fulltext");
            BowSearchPrefixImpl pAlias = new BowSearchPrefixImpl();
            pAlias.setBowUser(userId);
            pAlias.setPrefix(aliasPrefix + prefixSeparator);
            pAlias.setSearch("search.alias");
            pAlias.setSuggestion("suggestion.alias");
            BowSearchPrefixImpl pDefault = new BowSearchPrefixImpl();
            if (StringUtils.equals((CharSequence)defaultAction, (CharSequence)webSearchPrefix)) {
                pDefault.getWikitty().replaceWith(pWeb.getWikitty(), true);
            } else if (StringUtils.equals((CharSequence)defaultAction, (CharSequence)tagSearchPrefix)) {
                pDefault.getWikitty().replaceWith(pTag.getWikitty(), true);
            } else if (StringUtils.equals((CharSequence)defaultAction, (CharSequence)fullTextSearchPrefix)) {
                pDefault.getWikitty().replaceWith(pFullText.getWikitty(), true);
            } else if (StringUtils.equals((CharSequence)defaultAction, (CharSequence)aliasPrefix)) {
                pDefault.getWikitty().replaceWith(pAlias.getWikitty(), true);
            }
            pDefault.setPrefix("");
            BowSearchPrefixImpl pDefaultPrefix = new BowSearchPrefixImpl();
            if (StringUtils.equals((CharSequence)defaultPrefix, (CharSequence)webSearchPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pWeb.getWikitty(), true);
            } else if (StringUtils.equals((CharSequence)defaultPrefix, (CharSequence)tagSearchPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pTag.getWikitty(), true);
            } else if (StringUtils.equals((CharSequence)defaultPrefix, (CharSequence)fullTextSearchPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pFullText.getWikitty(), true);
            } else if (StringUtils.equals((CharSequence)defaultPrefix, (CharSequence)aliasPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pAlias.getWikitty(), true);
            }
            pDefaultPrefix.setPrefix(prefixSeparator);
            ArrayList<Wikitty> toStore = new ArrayList<Wikitty>();
            toStore.add(pWeb.getWikitty());
            toStore.add(pTag.getWikitty());
            toStore.add(pFullText.getWikitty());
            toStore.add(pAlias.getWikitty());
            toStore.add(pDefault.getWikitty());
            toStore.add(pDefaultPrefix.getWikitty());
            WikittyServiceEnhanced wse = new WikittyServiceEnhanced(service);
            service.store(null, toStore, false);
        }
    }

    public Wikitty migrate(WikittyService service, Wikitty oldWikitty, Wikitty newWikitty, WikittyExtension oldExt, WikittyExtension newExt) {
        String oldVersion;
        Wikitty result = super.migrate(service, oldWikitty, newWikitty, oldExt, newExt);
        if ("BowPreference".equals(newExt.getName()) && VersionUtil.smallerThan((String)(oldVersion = oldExt.getVersion()), (String)"5.0")) {
            this.migrateBowPrefix(service, oldWikitty, result);
        }
        return result;
    }
}

