/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowBookmarkImpl;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.ElementField;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

/*
 * Exception performing whole class analysis ignored.
 */
public class BookmarkUtils {
    public static Log log = LogFactory.getLog(BookmarkUtils.class);

    public static WikittyQueryMaker addEqUser(WikittyQueryMaker search, String userId) {
        search.or();
        search.eq("WikittyAuthorisation.owner", (Object)userId);
        search.eq("WikittyAuthorisation.reader", (Object)userId);
        search.eq("WikittyAuthorisation.writer", (Object)userId);
        search.eq("WikittyAuthorisation.admin", (Object)userId);
        search.close();
        return search;
    }

    public static WikittyQuery getBookmarkListCriteriaByUser(BowUser user, String tagLine, String fullTextLine, String order, int first) {
        WikittyQueryMaker search = (WikittyQueryMaker)new WikittyQueryMaker().and();
        BookmarkUtils.addEqUser((WikittyQueryMaker)search, (String)user.getWikittyId());
        if (StringUtils.isNotBlank((CharSequence)fullTextLine)) {
            search.keyword((Object)fullTextLine);
        }
        if (StringUtils.isNotBlank((CharSequence)tagLine)) {
            Set tags = BowUtils.getWords((String)tagLine);
            search.containsAll("WikittyLabel.labels", (Collection)tags);
        }
        WikittyQuery criteria = search.end();
        criteria.addFacetField((Element)BowBookmark.ELEMENT_FIELD_WIKITTYLABEL_LABELS);
        criteria.setFacetLimit(user.getTags());
        criteria.setOffset(first);
        criteria.setLimit(user.getBookmarks());
        boolean sortOrderAscending = StringUtils.startsWith((CharSequence)order, (CharSequence)"asc");
        ElementField sortOrderField = null;
        if (StringUtils.equals((CharSequence)order, (CharSequence)"ascName")) {
            sortOrderField = BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_DESCRIPTION;
        } else if (StringUtils.equals((CharSequence)order, (CharSequence)"ascDate")) {
            sortOrderField = BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_CREATIONDATE;
        } else if (StringUtils.equals((CharSequence)order, (CharSequence)"ascClick")) {
            sortOrderField = BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_CLICK;
        } else if (StringUtils.equals((CharSequence)order, (CharSequence)"descName")) {
            sortOrderField = BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_DESCRIPTION;
        } else if (StringUtils.equals((CharSequence)order, (CharSequence)"descDate")) {
            sortOrderField = BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_CREATIONDATE;
        } else if (StringUtils.equals((CharSequence)order, (CharSequence)"descClick")) {
            sortOrderField = BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_CLICK;
        }
        if (sortOrderField == null) {
            sortOrderField = BowBookmark.ELEMENT_FIELD_BOWBOOKMARK_CLICK;
            sortOrderAscending = false;
        }
        if (sortOrderAscending) {
            criteria.setSortAscending(new Element[]{sortOrderField});
        } else {
            criteria.setSortDescending(new Element[]{sortOrderField});
        }
        return criteria;
    }

    public static BowBookmark createBookmark(String url, String nameAndTags, BowUser user) {
        String name = BowUtils.normalizeString((String)nameAndTags);
        String tags = "";
        int nameIndex = name.lastIndexOf(124);
        if (nameIndex > 0) {
            tags = name.substring(nameIndex + 1);
            name = name.substring(0, nameIndex);
        }
        BowBookmark bookmark = BookmarkUtils.createBookmark((String)url, (String)name, (String)tags, (BowUser)user, (String)"", (String)"", null);
        return bookmark;
    }

    public static BowBookmark createBookmark(String url, String name, String tags, BowUser user, String privateAlias, String publicAlias, Date date) {
        BowBookmarkImpl bookmark = new BowBookmarkImpl();
        bookmark.setDescription(BowUtils.normalizeString((String)name));
        bookmark.addAllLabels((Collection)BowUtils.getWords((String)tags));
        bookmark.setLink(BowUtils.normalizeUrl((String)url));
        bookmark.setClick(0);
        bookmark.setOwner(user.getWikittyId());
        bookmark.addReader(new String[]{user.getWikittyId()});
        bookmark.setCreationDate(BowUtils.normalizeDate((Date)date));
        bookmark.setPrivateAlias(BowUtils.normalizeString((String)privateAlias));
        bookmark.setPublicAlias(BowUtils.normalizeString((String)publicAlias));
        return bookmark;
    }

    public static void updateBookmark(BowBookmark bookmark, String name, String link, String tags, String privateAlias, String publicAlias) {
        bookmark.setDescription(BowUtils.normalizeString((String)name));
        bookmark.setLink(BowUtils.normalizeUrl((String)link));
        bookmark.setLabels(BowUtils.getWords((String)tags));
        bookmark.setPrivateAlias(BowUtils.normalizeString((String)privateAlias));
        bookmark.setPublicAlias(BowUtils.normalizeString((String)publicAlias));
    }

    public static String getBookmarkTagsString(BowBookmark bookmark) {
        Set tags;
        if (bookmark != null && (tags = bookmark.getLabels()) != null) {
            return StringUtil.join((Iterable)tags, (String)" ", (boolean)true);
        }
        return "";
    }

    public static byte[] getScreenshot(String url) {
        byte[] result = null;
        try {
            String ssu = BowConfig.getScreenshotURL();
            if (StringUtils.isNotBlank((CharSequence)ssu)) {
                url = URLEncoder.encode(url, "UTF-8");
                String imageUrl = String.format(ssu, url);
                result = BookmarkUtils.getImage((String)imageUrl);
            }
        }
        catch (Exception eee) {
            log.info((Object)("Can't encode URL: " + url), (Throwable)eee);
        }
        return result;
    }

    public static byte[] getFavicon(String urlString) {
        byte[] result = null;
        try {
            String favicon = null;
            Document doc = Jsoup.connect((String)urlString).get();
            org.jsoup.nodes.Element link = doc.head().select("link[rel~=(shortcut icon|icon)]").first();
            if (link != null) {
                favicon = link.attr("abs:href");
            }
            if (favicon == null) {
                URL url = new URI(urlString).toURL();
                URL favURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/favicon.ico");
                favicon = favURL.toExternalForm();
            }
            result = BookmarkUtils.getImage((String)favicon);
            return result;
        }
        catch (Exception eee) {
            log.info((Object)("Can't parse URL: " + urlString), (Throwable)eee);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getImage(String url) {
        byte[] result = null;
        try {
            log.debug((Object)("try to connect get image : " + url));
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            try {
                HttpEntity entity = response.getEntity();
                result = IOUtils.toByteArray((InputStream)entity.getContent());
                EntityUtils.consume((HttpEntity)entity);
            }
            finally {
                response.close();
            }
        }
        catch (Exception eee) {
            log.info((Object)("Can't get result for url: " + url), (Throwable)eee);
        }
        return result;
    }
}

