/*
 * #%L
 * bow
 * 
 * $Id: LaxLoginInterceptor.java 357 2013-09-19 09:27:16Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.2/bow-ui/src/main/java/org/chorem/bow/interceptor/LaxLoginInterceptor.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;

import java.util.Map;

/**
 * Interceptor used to login user is inforamtion existe, otherwize do nothing
 */
public class LaxLoginInterceptor extends AbstractInterceptor {
    private static final long serialVersionUID = -7520186185205372272L;

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        Map<String, Object> session = ActionContext.getContext().getSession();

        BowSession bowSession = BowSession.getBowSession(session);
        BowUser user = bowSession.getUser();
        String result = null;

        //If the user isn't logged in
        if (user == null) {
            Map<String, Object> params = ActionContext.getContext().getParameters();
            //Retrieves the token value in URL
            String[] token = (String[]) params.get("token");

            if (token != null && !token[0].isEmpty()) {
                //Retrieves the user by token
                user = BowUtils.checkToken(bowSession, token[0]);

                //If the token is valid
                if (user != null) {
                    //Authenticates the user
                    bowSession.setUser(user);
                }
            }
        }

        result = invocation.invoke();

        return result;
    }
}
