/*
 * #%L
 * bow
 * 
 * $Id: OpenSearchSuggestionAction.java 360 2013-09-24 17:54:39Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.2/bow-ui/src/main/java/org/chorem/bow/action/opensearch/OpenSearchSuggestionAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.opensearch;

import com.opensymphony.xwork2.ActionContext;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowConfig;

import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.struts2.ServletActionContext;
import org.chorem.bow.BowSearchPrefix;
import org.nuiton.util.ApplicationConfig;

/**
 * Retourne les suggestions pour l'opensearch en fonction de ce qui a ete deja
 * saisi
 *
 * @author poussin
 */
public class OpenSearchSuggestionAction extends OpenSearchBaseAction {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(OpenSearchSuggestionAction.class);

    private static final long serialVersionUID = 1L;

    public static OpenSearchSuggestionAction getAction() {
        Object action = ActionContext.getContext().get(CONTEXT_ACTION_KEY);
        return (OpenSearchSuggestionAction) action;
    }

    protected transient InputStream inputStream;

    public InputStream getInputStream() {
        return inputStream;
    }

    @Override
    protected String executePrefixAction(BowSearchPrefix foundPrefix, String query) {
        String result = String.format("['%s', []]", query);
        try {
            log.trace("######################### executePrefixAction #################" + query + " - " + foundPrefix);
            String action;

            ApplicationConfig config = BowConfig.getConfig();
            
            if (foundPrefix == null) {
                action = BowConfig.getSearchEngine();
            } else {
                action = foundPrefix.getSuggestion();
            }

            // des alias peuvent exister dans la configuration
            String optionkey = "bow.prefix." + action;
            if (config.hasOption(optionkey)) {
                action = config.getOption(optionkey);
            }

            action = action.replace("{searchTerms}", URLEncoder.encode(query, "UTF-8"));

            if (!StringUtils.startsWith(action, "http")) {
                String serveur =
                        ServletActionContext.getRequest().getScheme() + "://" +
                        ServletActionContext.getRequest().getServerName() + ":" +
                        ServletActionContext.getRequest().getServerPort() +
                        ServletActionContext.getRequest().getContextPath();
                if (!StringUtils.startsWith(action, "/")) {
                    action = "/" + action;
                }
                action = serveur + action + "&token=" + getBowSession().getPermanentToken();
            }

//        action = ServletActionContext.getResponse().encodeURL(action);
            try {
                log.debug("try to connect to : " + action);
                // ne fonctionne pas (rien ne se passe, pas de requete envoyee :()
//            result = Request.Get(action)
//                    .connectTimeout(1000)
//                    .socketTimeout(1000)
//                    .execute().returnContent().asString();


                CloseableHttpClient httpclient = HttpClients.createDefault();
                HttpGet httpGet = new HttpGet(action);
                CloseableHttpResponse response = httpclient.execute(httpGet);
                
                try {
                    HttpEntity entity = response.getEntity();
                    result = IOUtils.toString(entity.getContent());
                    // ensure it is fully consumed
                    EntityUtils.consume(entity);
                } finally {
                    response.close();
                }
            } catch (Exception eee) {
                log.info("Can't get result for url: " + action, eee);
            } finally {
                log.debug("suggestion: " + result);
            }
        } catch (UnsupportedEncodingException eee) {
            log.info("Can't make suggestion for: " + query, eee);
        }
        inputStream = new ReaderInputStream(new StringReader(result));

        return SUCCESS;
    }

}