package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class BowUserAbstract extends BusinessEntityImpl implements BowUser {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionBowUser;

    private static final long serialVersionUID = 3703141106569523253L;

    @Override
    public String getPermanentToken() {
String value = BowUserHelper.getPermanentToken(getWikitty());
return value;
}

    @Override
    public void setPermanentToken(String permanentToken) {
String oldValue = getPermanentToken();
BowUserHelper.setPermanentToken(getWikitty(), permanentToken);
getPropertyChangeSupport().firePropertyChange(BowUser.FIELD_BOWUSER_PERMANENTTOKEN, oldValue, getPermanentToken());
}

    @Override
    public String getLogin() {
String value = WikittyUserHelper.getLogin(getWikitty());
return value;
}

    @Override
    public void setLogin(String login) {
String oldValue = getLogin();
WikittyUserHelper.setLogin(getWikitty(), login);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    @Override
    public String getPassword() {
String value = WikittyUserHelper.getPassword(getWikitty());
return value;
}

    @Override
    public void setPassword(String password) {
String oldValue = getPassword();
WikittyUserHelper.setPassword(getWikitty(), password);
getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    @Override
    public int getTags() {
int value = BowPreferenceHelper.getTags(getWikitty());
return value;
}

    @Override
    public void setTags(int tags) {
int oldValue = getTags();
BowPreferenceHelper.setTags(getWikitty(), tags);
getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_TAGS, oldValue, getTags());
}

    @Override
    public int getBookmarks() {
int value = BowPreferenceHelper.getBookmarks(getWikitty());
return value;
}

    @Override
    public void setBookmarks(int bookmarks) {
int oldValue = getBookmarks();
BowPreferenceHelper.setBookmarks(getWikitty(), bookmarks);
getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS, oldValue, getBookmarks());
}

    @Override
    public String getColors() {
String value = BowPreferenceHelper.getColors(getWikitty());
return value;
}

    @Override
    public void setColors(String colors) {
String oldValue = getColors();
BowPreferenceHelper.setColors(getWikitty(), colors);
getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_COLORS, oldValue, getColors());
}

    public BowUserAbstract() {
        super();
}

    public BowUserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public BowUserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionBowUser = new WikittyExtension(EXT_BOWUSER,
                "2.0", // version
                WikittyUtil.tagValuesToMap(" version=\"2.0\""), // tag/values
                WikittyUser.EXT_WIKITTYUSER + "," + BowPreference.EXT_BOWPREFERENCE,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String permanentToken fieldIndex=\"1\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyUserAbstract.extensions); 
        // current after requires ones

        exts.addAll(BowPreferenceAbstract.extensions); 
        // current after requires ones

        exts.add(extensionBowUser);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return BowUserHelper.toString(getWikitty());
}

} //BowUserAbstract
