/*
 * #%L
 * bow
 * 
 * $Id: BowSearchResult.java 360 2013-09-24 17:54:39Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.2/bow-ui/src/main/java/org/chorem/bow/BowSearchResult.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQueryResult;

/**
 * Cette classe permet de stocker le resutlat d'une recherche
 * - la liste des tags qui ont servi pour la recherche
 * - la chaine fulltext de recherche
 * - la liste des bookmarks
 * - la liste des tags
 *
 * @author poussin
 * @version $Revision: 360 $
 *          <p/>
 *          Last update: $Date: 2013-09-24 19:54:39 +0200 (Tue, 24 Sep 2013) $
 *          by : $Author: bpoussin $
 */
public class BowSearchResult {

    private static final Log log = LogFactory.getLog(BowSearchResult.class);

    /** nombre total de bookmark trouve */
    protected int bookmarkCount;

    protected List<BowBookmark> bookmarks;

    protected List<FacetTopic> tagsCloud;

    protected int tmax = -1;

    protected int tmin = -1;

    /**
     * Construit l'objet en passant en parametre tout ce qu'il faut pour faire
     * la recherche
     *
     * @param result
     * @param tagLine (optionel) le liste des tags a rechercher
     */
    public BowSearchResult(WikittyQueryResult<BowBookmark> result, String tagLine) {

        bookmarkCount = result.getTotalResult();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Find %s items, used %s",
                                    bookmarkCount, result.size()));
        }

        setBookmarks(result.getAll());

        List<FacetTopic> topics = result.getTopic(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS);
        if (log.isDebugEnabled()) {
            log.debug(String.format("There are %s tag in cloud",
                                    CollectionUtils.isEmpty(topics) ? 0 : topics.size()));
        }
        setTagCloud(topics, tagLine);
    }

    protected void setTagCloud(List<FacetTopic> cpy, String excludeTag) {
        tagsCloud = new ArrayList<FacetTopic>();
        if (cpy != null) {
            tagsCloud.addAll(cpy);

            // on ne met pas dans le cloud les tags qui ont servi pour la recherche
            List<FacetTopic> save = new ArrayList<FacetTopic>(tagsCloud);
            // on recupere les tags dans un set pour optimiser la recherche
            Set<String> tagsSearch = BowUtils.getWords(excludeTag);

            for (Iterator<FacetTopic> i = tagsCloud.iterator(); i.hasNext(); ) {
                FacetTopic topic = i.next();
                String name = topic.getTopicName();
                if (tagsSearch.contains(name)) {
                    i.remove();
                }
            }

            // on calcul la frequence pour le calcul de la taille dans le cloud
            tmax = -1; // correspond to the most tag frequency in the tag cloud
            tmin = -1; // correspond to the less tag frequency in the tag cloud
            for (FacetTopic tag : tagsCloud) {
                int value = tag.getCount();
                if (tmax < value) { // search the most tag frequancy
                    tmax = value;
                }
                if (tmin == -1) {
                    tmin = value;
                } else if (tmin > value) { // search less tag frequency
                    tmin = value;
                }
            }

        }
    }

    public int getFont(int ti) {
        int font = 1;
        if (tmax > tmin) {
            font = 30 * (ti - tmin) / (tmax - tmin); // get the font size for a tag frequency
        }
        if (font < 10) {
            font = 10;
        }
        return font;
    }

    public List<FacetTopic> getTagsCloud() {
        return tagsCloud;
    }

    public List<BowBookmark> getBookmarks() {
        return bookmarks;
    }

    protected void setBookmarks(List<BowBookmark> bookmarks) {
        this.bookmarks = new ArrayList<BowBookmark>();
        if (bookmarks != null) {
            this.bookmarks.addAll(bookmarks);
        }
    }

    public int getTmin() {
        return tmin;
    }

    public int getTmax() {
        return tmax;
    }

    public int getBookmarkCount() {
        return bookmarkCount;
    }

}
