package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class BowPreferenceAbstract extends BusinessEntityImpl implements BowPreference {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionBowPreference;

    private static final long serialVersionUID = 3905808788386636386L;

    @Override
    public int getTags() {
int value = BowPreferenceHelper.getTags(getWikitty());
return value;
}

    @Override
    public void setTags(int tags) {
int oldValue = getTags();
BowPreferenceHelper.setTags(getWikitty(), tags);
getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_TAGS, oldValue, getTags());
}

    @Override
    public int getBookmarks() {
int value = BowPreferenceHelper.getBookmarks(getWikitty());
return value;
}

    @Override
    public void setBookmarks(int bookmarks) {
int oldValue = getBookmarks();
BowPreferenceHelper.setBookmarks(getWikitty(), bookmarks);
getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_BOOKMARKS, oldValue, getBookmarks());
}

    @Override
    public String getColors() {
String value = BowPreferenceHelper.getColors(getWikitty());
return value;
}

    @Override
    public void setColors(String colors) {
String oldValue = getColors();
BowPreferenceHelper.setColors(getWikitty(), colors);
getPropertyChangeSupport().firePropertyChange(BowPreference.FIELD_BOWPREFERENCE_COLORS, oldValue, getColors());
}

    public BowPreferenceAbstract() {
        super();
}

    public BowPreferenceAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public BowPreferenceAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionBowPreference = new WikittyExtension(EXT_BOWPREFERENCE,
                "5.0", // version
                WikittyUtil.tagValuesToMap(" version=\"5.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "Numeric tags fieldIndex=\"1\"", 
                                             "Numeric bookmarks fieldIndex=\"2\"", 
                                             "String colors fieldIndex=\"3\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionBowPreference);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return BowPreferenceHelper.toString(getWikitty());
}

} //BowPreferenceAbstract
