/*
 * #%L
 * BOW UI
 * 
 * $Id: BowMigrationPreference.java 360 2013-09-24 17:54:39Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.2/bow-ui/src/main/java/org/chorem/bow/BowMigrationPreference.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;


import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRename;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.VersionUtil;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

/**
 * Migre les données depuis la version 0.6 vers la version 1.1.
 * On suppose que les données sont convenablement indexee.
 * <p/>
 * <li> ajout du champs BowBookmark.authentificationInfo (rien a faire pour la migration)
 * <li> suppression de BowBookmark.bowUser
 * <li> BowBookmark depend de WikittyAuthorisation
 * <p/>
 * la valeur de BowBookmark.bowUser est maintenant stockee dans
 * WikittyAuthorisation.owner et WikittyAuthorisation.reader
 * pour que par defaut seul le owner est les droits de lecture sur l'item
 *
 * @author poussin
 * @version $Revision: 360 $
 *          <p/>
 *          Last update: $Date: 2013-09-24 19:54:39 +0200 (Tue, 24 Sep 2013) $
 *          by : $Author: bpoussin $
 */
public class BowMigrationPreference extends WikittyExtensionMigrationRename {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(BowMigrationPreference.class);

    /**
     * Remplacement des prefix predefini dans BowPreference par une extension
     * BowPrefix qui permet d'en creer autant qu'on en souhaite
     *
     * @param service
     * @param oldWikitty
     * @param newWikitty
     */
    protected void migrateBowPrefix(WikittyService service, Wikitty oldWikitty, Wikitty newWikitty) {
        // On met juste a jour les données avec le champs supprimer bowUser
        String userId = oldWikitty.getWikittyId();

        if (userId != null) {
            String prefixSeparator = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "prefixSeparator");

            String defaultAction = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "defaultAction");
            String defaultPrefix = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "defaultPrefix");

            String tagSearchPrefix = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "tagSearchPrefix");
            String fullTextSearchPrefix = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "fullTextSearchPrefix");
            String webSearchPrefix = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "webSearchPrefix");
            String aliasPrefix = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "aliasPrefix");

            String searchEngineUrlResults = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "searchEngineUrlResults");
            String searchEngineUrlSuggestions = (String) oldWikitty.getFqField(
                    BowPreference.EXT_BOWPREFERENCE + WikittyUtil.FQ_FIELD_NAME_SEPARATOR
                    + "searchEngineUrlSuggestions");

            BowSearchPrefixImpl pWeb = new BowSearchPrefixImpl();
            pWeb.setBowUser(userId);
            pWeb.setPrefix(webSearchPrefix + prefixSeparator);
            pWeb.setSearch(searchEngineUrlResults);
            pWeb.setSuggestion(searchEngineUrlSuggestions);

            BowSearchPrefixImpl pTag = new BowSearchPrefixImpl();
            pTag.setBowUser(userId);
            pTag.setPrefix(tagSearchPrefix + prefixSeparator);
            pTag.setSearch("search.tag");
            pTag.setSuggestion("suggestion.tag");

            BowSearchPrefixImpl pFullText = new BowSearchPrefixImpl();
            pFullText.setBowUser(userId);
            pFullText.setPrefix(fullTextSearchPrefix + prefixSeparator);
            pFullText.setSearch("search.fulltext");
            pFullText.setSuggestion("suggestion.fulltext");

            BowSearchPrefixImpl pAlias = new BowSearchPrefixImpl();
            pAlias.setBowUser(userId);
            pAlias.setPrefix(aliasPrefix + prefixSeparator);
            pAlias.setSearch("search.alias");
            pAlias.setSuggestion("suggestion.alias");

            BowSearchPrefixImpl pDefault = new BowSearchPrefixImpl();
            if (StringUtils.equals(defaultAction, webSearchPrefix)) {
                pDefault.getWikitty().replaceWith(pWeb.getWikitty(), true);
            } else if (StringUtils.equals(defaultAction, tagSearchPrefix)) {
                pDefault.getWikitty().replaceWith(pTag.getWikitty(), true);
            } else if (StringUtils.equals(defaultAction, fullTextSearchPrefix)) {
                pDefault.getWikitty().replaceWith(pFullText.getWikitty(), true);
            } else if (StringUtils.equals(defaultAction, aliasPrefix)) {
                pDefault.getWikitty().replaceWith(pAlias.getWikitty(), true);
            }
            pDefault.setPrefix("");

            BowSearchPrefixImpl pDefaultPrefix = new BowSearchPrefixImpl();
            if (StringUtils.equals(defaultPrefix, webSearchPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pWeb.getWikitty(), true);
            } else if (StringUtils.equals(defaultPrefix, tagSearchPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pTag.getWikitty(), true);
            } else if (StringUtils.equals(defaultPrefix, fullTextSearchPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pFullText.getWikitty(), true);
            } else if (StringUtils.equals(defaultPrefix, aliasPrefix)) {
                pDefaultPrefix.getWikitty().replaceWith(pAlias.getWikitty(), true);
            }
            pDefaultPrefix.setPrefix(prefixSeparator);

            ArrayList<Wikitty> toStore = new ArrayList<Wikitty>();
            toStore.add(pWeb.getWikitty());
            toStore.add(pTag.getWikitty());
            toStore.add(pFullText.getWikitty());
            toStore.add(pAlias.getWikitty());
            toStore.add(pDefault.getWikitty());
            toStore.add(pDefaultPrefix.getWikitty());

            WikittyServiceEnhanced wse = new WikittyServiceEnhanced(service);
            service.store(null, toStore, false);
            
//            WikittyProxy proxy = new WikittyProxy(service);
//            proxy.store(pWeb, pTag, pFullText, pAlias, pDefault, pDefaultPrefix);
        }
    }

    @Override
    public Wikitty migrate(WikittyService service, Wikitty oldWikitty, Wikitty newWikitty,
                           WikittyExtension oldExt, WikittyExtension newExt) {

        // on laisse l'implantation par defaut migrer tout ce qu'il faut
        Wikitty result = super.migrate(service, oldWikitty, newWikitty, oldExt, newExt);

        if (BowPreference.EXT_BOWPREFERENCE.equals(newExt.getName())) {
            String oldVersion = oldExt.getVersion();
            if (VersionUtil.smallerThan(oldVersion, "5.0")) {
                migrateBowPrefix(service, oldWikitty, result);
            }
        }
        
        return result;
    }
////147e923b-3921-4b17-a88c-43495b477a8a
//    public static void migrate(WikittyProxy proxy) {
//        log.info("Migration");
//
//        int MAX = 1000;
//
//        Criteria criteria = Search.query().rTrue().criteria();
//
//        int i = 0;
//        int count = 0;
//        PagedResult<Wikitty> wikitties;
//        do {
//            criteria.setFirstIndex(i);
//            criteria.setEndIndex(i += MAX);
//            wikitties = proxy.findAllByCriteria(criteria);
//            List<Wikitty> ws = wikitties.getAll();
//            proxy.storeWikitty(ws);
//            count += ws.size();
//        } while (wikitties.size() >= MAX);
//        log.info(String.format("Migration of %s Wikitties done", count));
//    }
//
//    // only here to simplify test and debug of migration, this permit to migrate
//    // datas in developpement environnement directly without launch bow web app
//    public static void main(String... args) {
//        BowProxy proxy = BowProxy.getInstance(null);
//        proxy.syncSearchEngine();
//        migrate(proxy);
//    }
}
