/*
 * #%L
 * bow
 * 
 * $Id: PreferenceBaseAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/preference/PreferenceBaseAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.preference;

import com.opensymphony.xwork2.ActionContext;
import org.apache.commons.lang.StringUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowImport;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Change les preferences de l'utilisateur (couleur, password, email, ...)
 *
 * @author poussin
 */
public class PreferenceBaseAction extends BowBaseAction {

    private static final long serialVersionUID = -58341106356599721L;

    public static PreferenceBaseAction getAction() {
        Object action = ActionContext.getContext().get(CONTEXT_ACTION_KEY);
        return (PreferenceBaseAction) action;
    }

    public enum DefaultPrefix {TAG, FULLTEXT, WEB, ALIAS}

    /** la liste des differentes data que l'on peut charger */
    protected enum PreferenceType {
        USER_PREF, SITE_PREF, LABELS, IMPORTS
    }

    protected String email;

    protected String newPassword;

    protected String currentPassword;

    protected String confirmNewPassword;

    protected String colors;

    protected String tagsNb;

    protected String bookmarksHomePage;

    protected String searchEngineUrlSuggestions;

    protected String searchEngineUrlResults;

    protected String separator;

    protected String tagPrefix;

    protected String fulltextPrefix;

    protected String webPrefix;

    protected String aliasPrefix;

    protected DefaultPrefix defaultPrefix;

    protected DefaultPrefix defaultAction;

    protected List<FacetTopic> labels;

    protected String[] selectedLabels;

    protected String rename;

    protected String delete;

    protected String newLabel;

    protected String update;

    protected Map<String, Integer> bookmarksImportDate;

    public String getNewLabel() {
        return newLabel;
    }

    public void setNewLabel(String newLabel) {
        this.newLabel = newLabel;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public String getRename() {
        return rename;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public String getDelete() {
        return delete;
    }

    /** @return the colors */
    public String getColors() {
        return colors;
    }

    /** @param colors the colors to set */
    public void setColors(String colors) {
        this.colors = colors;
    }

    /** @return the tagsNb */
    public String getTagsNb() {
        return tagsNb;
    }

    /** @param tagsNb the tagsNb to set */
    public void setTagsNb(String tagsNb) {
        this.tagsNb = tagsNb;
    }

    /** @return the bookmarksHomePage */
    public String getBookmarksHomePage() {
        return bookmarksHomePage;
    }

    /** @param bookmarksHomePage the bookmarksHomePage to set */
    public void setBookmarksHomePage(String bookmarksHomePage) {
        this.bookmarksHomePage = bookmarksHomePage;
    }

    /** @return the searchEngineUrlSuggestions */
    public String getSearchEngineUrlSuggestions() {
        return searchEngineUrlSuggestions;
    }

    /** @param searchEngineUrlSuggestions the searchEngineUrlSuggestions to set */
    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        this.searchEngineUrlSuggestions = searchEngineUrlSuggestions;
    }

    /** @return the searchEngineUrlResults */
    public String getSearchEngineUrlResults() {
        return searchEngineUrlResults;
    }

    /** @param searchEngineUrlResults the searchEngineUrlResults to set */
    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        this.searchEngineUrlResults = searchEngineUrlResults;
    }

    public String getSeparator() {
        return separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getTagPrefix() {
        return tagPrefix;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }

    public String getFulltextPrefix() {
        return fulltextPrefix;
    }

    public void setFulltextPrefix(String fulltextPrefix) {
        this.fulltextPrefix = fulltextPrefix;
    }

    public String getWebPrefix() {
        return webPrefix;
    }

    public void setWebPrefix(String webPrefix) {
        this.webPrefix = webPrefix;
    }

    public String getAliasPrefix() {
        return aliasPrefix;
    }

    public void setAliasPrefix(String aliasPrefix) {
        this.aliasPrefix = aliasPrefix;
    }

    public DefaultPrefix getDefaultPrefix() {
        return defaultPrefix;
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = DefaultPrefix.valueOf(defaultPrefix);
    }

    public DefaultPrefix getDefaultAction() {
        return defaultAction;
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = DefaultPrefix.valueOf(defaultAction);
    }

    /** @return the email */
    public String getEmail() {
        return email;
    }

    /** @param email the email to set */
    public void setEmail(String email) {
        this.email = email;
    }

    /** @return the newPassword */
    public String getNewPassword() {
        return newPassword;
    }

    /** @param newPassword the newPassword to set */
    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    /** @return the currentPassword */
    public String getCurrentPassword() {
        return currentPassword;
    }

    /** @param currentPassword the currentPassword to set */
    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    /** @return the confirmNewPassword */
    public String getConfirmNewPassword() {
        return confirmNewPassword;
    }

    /** @param confirmNewPassword the confirmNewPassword to set */
    public void setConfirmNewPassword(String confirmNewPassword) {
        this.confirmNewPassword = confirmNewPassword;
    }

    /** @return the update */
    public String getUpdate() {
        return update;
    }

    /** @param update the update to set */
    public void setUpdate(String update) {
        this.update = update;
    }

    /** @return the bookmarksImportDate */
    public Map<String, Integer> getBookmarksImportDate() {
        return bookmarksImportDate;
    }

    /** @param bookmarksImportDate the bookmarksImportDate to set */
    public void setBookmarksImportDate(Map<String, Integer> bookmarksImportDate) {
        this.bookmarksImportDate = bookmarksImportDate;
    }

    public List<FacetTopic> getLabels() {
        return labels;
    }

    public String[] getSelectedLabels() {
        return selectedLabels;
    }

    public void setSelectedLabels(String[] selectedLabels) {
        this.selectedLabels = selectedLabels;
    }

    /**
     * Date est une date mais au format String qui vient de Solr
     * Elle est de la forme '2011-08-18T00:25:16.028Z'
     * qui n'est pas presentable a l'utilisateur
     * On la remet sous une vrai forme date
     * <p/>
     * Cette methode est utilise dans la JSP de rendu
     *
     * @param date
     * @return
     */
    public Date stringToDate(String date) {
        try {
            Date result = WikittyUtil.parseDate(date);
            return result;
        } catch (ParseException eee) {
            return new Date(0);
        }
    }

    /**
     * Load les données sauf celle que l'on demande d'exclure du load
     *
     * @param exclude
     */
    protected void load(PreferenceType... exclude) {
        PreferenceType[] list = PreferenceType.values();
        for (PreferenceType type : exclude) {
            list[type.ordinal()] = null;
        }

        for (PreferenceType type : list) {
            if (type != null) {
                switch (type) {
                    case USER_PREF:
                        loadUserPref();
                        break;
                    case SITE_PREF:
                        loadSitePref();
                        break;
                    case LABELS:
                        loadLabels();
                        break;
                    case IMPORTS:
                        loadImport();
                        break;
                    default:
                        // do nothing
                        break;
                }
            }
        }
    }

    /** charge les info de l'utilisateur qu'il peut modifier */
    protected void loadUserPref() {
        BowSession session = getBowSession();
        BowUser user = session.getUser();

        setEmail(user.getLogin());
    }

    /** Charge les preferences utilisateur pour le site */
    protected void loadSitePref() {
        BowSession session = getBowSession();
        BowUser user = session.getUser();

        if (log.isDebugEnabled()) {
            log.debug("Load site pref for " + user);
        }

        setColors(user.getColors());
        setTagsNb(String.valueOf(user.getTags()));
        setBookmarksHomePage(String.valueOf(user.getBookmarks()));
        setSearchEngineUrlSuggestions(user.getSearchEngineUrlSuggestions());
        setSearchEngineUrlResults(user.getSearchEngineUrlResults());

        setSeparator(user.getPrefixSeparator());
        setTagPrefix(user.getTagSearchPrefix());
        setFulltextPrefix(user.getFullTextSearchPrefix());
        setWebPrefix(user.getWebSearchPrefix());
        setAliasPrefix(user.getAliasPrefix());

        defaultAction = getDefaultConst(user, user.getDefaultAction());
        defaultPrefix = getDefaultConst(user, user.getDefaultPrefix());

    }

    protected String getDefaultValue(BowUser user, DefaultPrefix constValue) {
        String result = user.getAliasPrefix();
        switch (constValue) {
            case TAG:
                result = user.getTagSearchPrefix();
                break;
            case FULLTEXT:
                result = user.getFullTextSearchPrefix();
                break;
            case WEB:
                result = user.getWebSearchPrefix();
                break;
            case ALIAS:
                result = user.getAliasPrefix();
                break;
            default:
                break;
        }
        return result;
    }

    protected DefaultPrefix getDefaultConst(BowUser user, String value) {
        DefaultPrefix result = DefaultPrefix.ALIAS;
        if (StringUtils.equals(value, user.getTagSearchPrefix())) {
            result = DefaultPrefix.TAG;
        } else if (StringUtils.equals(value, user.getFullTextSearchPrefix())) {
            result = DefaultPrefix.FULLTEXT;
        } else if (StringUtils.equals(value, user.getWebSearchPrefix())) {
            result = DefaultPrefix.WEB;
        } else if (StringUtils.equals(value, user.getAliasPrefix())) {
            result = DefaultPrefix.ALIAS;
        }
        return result;
    }

    /** Charge la liste des imports que l'utilisateur a fait */
    protected void loadImport() {
        BowSession session = getBowSession();
        BowProxy proxy = session.getProxy();
        BowUser user = session.getUser();

        Criteria criteria = Search.query()
                .exteq(BowImport.EXT_BOWIMPORT)
                .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, user.getWikittyId()).criteria()
                .addFacetField(BowImport.FQ_FIELD_BOWIMPORT_IMPORTDATE)
                .setFirstIndex(0).setEndIndex(0);

        List<FacetTopic> bookmarksImportDate =
                proxy.findAllByCriteria(BowImport.class, criteria)
                        .getTopic(BowImport.FQ_FIELD_BOWIMPORT_IMPORTDATE);

        // Extract imports
        Map<String, Integer> result = new HashMap<String, Integer>();
        for (FacetTopic facet : bookmarksImportDate) {
            String dateAsString = facet.getTopicName();
            int count = facet.getCount();
            result.put(dateAsString, count);
        }

        if (log.isDebugEnabled()) {
            log.debug("bookmarksByImportDate found : "
                      + result.size());
        }
        setBookmarksImportDate(result.isEmpty() ? null : result);
    }

    /** Charge dans la variable labels tous les labels de l'utilisateur. */
    protected void loadLabels() {
        BowSession session = getBowSession();
        BowProxy proxy = session.getProxy();
        BowUser user = session.getUser();
        String userId = user.getWikittyId();

        Criteria c = Search.query()
                .exteq(BowBookmark.EXT_WIKITTYLABEL)
                .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, userId)
                .criteria().setEndIndex(0) // on ne veut aucun resultat, c'est la facet dont on a besoin
                .setFacetMinCount(1) // on demande meme les labels avec 1 seul item
                .setFacetLimit(-1) // on demande tous les labels
                .addFacetField(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS);
        PagedResult<Wikitty> result = proxy.findAllByCriteria(c);
        // lorsqu'on demande tout (facetLimit(-1)), les topics sont trie
        // alphabetiquement pas besoin de les retrier
        labels = result.getTopic(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS);
    }

    /**
     * ACTION STRUTS
     * <p/>
     * Action executer lorsque l'utilisateur demande la page. Prepare toutes
     * les données pour la page JSP
     */
    @Override
    public String input() {
        String result = SUCCESS;

        try {
            // load all data
            load();
        } catch (Exception eee) {
            result = ERROR;
            addActionError(_("bow.error.internal"));
            log.error("Can't load data preference", eee);
        }
        return result;
    }
}
