/*
 * #%L
 * BOW UI
 * 
 * $Id: GenerateTokenAction.java 332 2011-08-31 12:30:50Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/preference/GenerateTokenAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.preference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;

/**
 * @author poussin
 * @version $Revision: 332 $
 *          <p/>
 *          Last update: $Date: 2011-08-31 14:30:50 +0200 (Wed, 31 Aug 2011) $
 *          by : $Author: bpoussin $
 */
public class GenerateTokenAction extends PreferenceBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(GenerateTokenAction.class);

    private static final long serialVersionUID = 1L;

    @Override
    public String execute() {
        try {
            BowUser user = getBowSession().getUser();
            BowProxy proxy = getBowProxy();

            String permanentToken = BowUtils.generateToken();
            user.setPermanentToken(permanentToken);
            proxy.store(user);

            String temporaryToken = BowUtils.generateToken();
            getBowSession().setTemporaryToken(temporaryToken);
            addActionMessage(_("bow.token.generate.successful"));
        } catch (Exception eee) {
            addActionError(_("bow.error.internal"));
            log.error("Can't regenerate token", eee);
        } finally {
            // on recharge les data apres l'action pour l'affichage
            load();
        }
        return SUCCESS;
    }

}
