/*
 * #%L
 * bow
 * 
 * $Id: ExportBookmarksAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/preference/ExportBookmarksAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.preference;

import org.apache.commons.io.IOUtils;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * Export son bookmark au format HTML
 *
 * @author poussin
 */
public class ExportBookmarksAction extends BowBaseAction {
    private static final long serialVersionUID = 45880214686011946L;

    protected transient InputStream inputStream;

    public InputStream getInputStream() {
        return inputStream;
    }

    /**
     * Export tous les bookmarks au format HTML tel que le fait les navigateurs
     *
     * @param bookmarks List<Bookmarks> bookmarks
     * @param out       le flux dans lequel il faut ecrire l'export
     * @return String   the html file
     * @throws IOException
     */
    protected void generateExportHtmlBookmark(List<BowBookmark> bookmarks, Writer out) throws IOException {
        out.write("<!DOCTYPE NETSCAPE-Bookmark-file-1>\n"
                  + "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\">\n"
                  + "<DL><p>\n");
        if (bookmarks != null) {
            for (BowBookmark bookmark : bookmarks) {
                if (bookmark != null) {
                    out.write("<DT><A HREF=\"");
                    out.write(bookmark.getLink() + "\" ");
                    Date date = bookmark.getCreationDate();
                    if (date != null) {
                        long milli = date.getTime();
                        String time = String.valueOf(milli / 1000);
                        out.write("ADD_DATE=\"" + time + "\" LAST_MODIFIED=\"" + time + "\" ");
                    }
                    out.write("LAST_CHARSET=\"UTF-8\" ");
                    Set<String> tags = bookmark.getLabels();
                    if (tags != null && !tags.isEmpty()) {
                        out.write("SHORTCUTURL=\""
                                  + BookmarkUtils.getBookmarkTagsString(bookmark) + "\"");
                    }
                    out.write(">" + bookmark.getDescription() + "</A>\n");
                }
            }
        }
        out.write("</DL><p>");
    }

    /** Exports the bookmarks in HTML format */
    @Override
    public String execute() {
        WikittyProxy proxy = getBowProxy();

        // get current user
        BowUser user = getBowSession().getUser();

        // Get all bookmark for user
        Criteria criteria = Search.query()
                .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, user.getWikittyId()).criteria();
        List<BowBookmark> bookmarks = proxy.findAllByCriteria(BowBookmark.class, criteria).getAll();

        // Export all
        BufferedWriter out = null;

        try {

            // Write result in temp file
            File tmp = File.createTempFile("bookmarks", ".tmp.html");

            tmp.deleteOnExit();
            out = new BufferedWriter(new FileWriter(tmp));
            generateExportHtmlBookmark(bookmarks, out);
            out.close();

            inputStream = new FileInputStream(tmp);
        } catch (IOException eee) {
            log.error("Error when exporting bookmarks to HTML : ", eee);
        } finally {
            IOUtils.closeQuietly(out);
        }
        return SUCCESS;
    }
}