/*
 * #%L
 * BOW UI
 * 
 * $Id: AdminTagAction.java 333 2011-08-31 12:32:26Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/preference/AdminTagAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.preference;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author poussin
 * @version $Revision: 333 $
 *          <p/>
 *          Last update: $Date: 2011-08-31 14:32:26 +0200 (Wed, 31 Aug 2011) $
 *          by : $Author: bpoussin $
 */
public class AdminTagAction extends PreferenceBaseAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log = LogFactory.getLog(AdminTagAction.class);

    private static final long serialVersionUID = 1L;

    /**
     * ACTION STRUTS
     * <p/>
     * Fait les modification demandé par l'utilisateur dans l'interface de
     * preference: renome ou supprime des labels. Si l'utilisateur demande le
     * remplacement de label on indiquant pas de nouveau label, alors la chaine
     * vide est utilisee.
     *
     * @return
     */
    @Override
    public String execute() {
        String result = SUCCESS;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Selected labels: " + Arrays.toString(selectedLabels));
                log.debug("action delete: " + delete + " rename: " + rename);
            }

            List<String> selectedLabelsList = Arrays.asList(selectedLabels);
            boolean isRename = StringUtils.isNotEmpty(rename);

            BowProxy proxy = getBowProxy();
            BowUser user = getBowSession().getUser();
            String userId = user.getWikittyId();

            Criteria c = Search.query()
                    .in(BowBookmark.FQ_FIELD_WIKITTYLABEL_LABELS, selectedLabelsList)
                    .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, userId)
                    .criteria();
            PagedResult<WikittyLabel> searchResult =
                    proxy.findAllByCriteria(WikittyLabel.class, c);

            List<WikittyLabel> toStore = new ArrayList<WikittyLabel>();
            for (WikittyLabel label : searchResult) {
                toStore.add(label);
                Set<String> l = label.getLabels();
                if (l != null) {
                    // on fait une copie, car l retourne est non modifiable
                    l = new HashSet<String>(l);
                    l.removeAll(selectedLabelsList);
                    if (isRename) {
                        l.add(newLabel);
                    }
                    label.setLabels(l);
                }
            }
            proxy.store(toStore);

        } catch (Exception eee) {
            addActionError(_("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        } finally {
            // on recharge les data apres l'action pour l'affichage
            load();
        }
        return result;

    }

}
