/*
 * #%L
 * bow
 * 
 * $Id: OpenSearchResultAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/opensearch/OpenSearchResultAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.opensearch;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

import javax.servlet.http.HttpServletResponse;

/**
 * Traite toutes les demandes faite via l'opensearch
 * a:, :, t:, ...
 *
 * @author poussin
 */
public class OpenSearchResultAction extends OpenSearchBaseAction implements ServletResponseAware {
    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static final Log log =
            LogFactory.getLog(OpenSearchResultAction.class);

    private static final long serialVersionUID = 1L;

    protected String redirectTo;

    protected transient HttpServletResponse response;

    /** @return the redirectTo */
    public String getRedirectTo() {
        return redirectTo;
    }

    @Override
    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    protected String executeTagSearchAction(String query) {
        redirectTo = BowUtils.redirectTo(query, null);
        return SUCCESS;
    }

    protected String executeFulltextSearchAction(String query) {
        redirectTo = BowUtils.redirectTo(null, query);
        return SUCCESS;
    }

    protected String executeWebSearchAction(String query) {
        // Search on the chosen search engine
        BowUser user = getBowSession().getUser();

        String result = user.getSearchEngineUrlResults();
        if (StringUtils.isEmpty(result)) {
            result = BowConfig.getSearchEngine();
        }
        result = result.replace("{searchTerms}", query);
        result = response.encodeRedirectURL(result);
        redirectTo = result;
        return SUCCESS;
    }

    protected String executeAliasSearchAction(String privateAlias) {
        BowUser user = getBowSession().getUser();
        WikittyProxy proxy = getBowProxy();
        Criteria criteria = Search.query()
                .eq(BowBookmark.FQ_FIELD_WIKITTYAUTHORISATION_OWNER, user.getWikittyId())
                .eq(BowBookmark.FQ_FIELD_BOWBOOKMARK_PRIVATEALIAS, privateAlias)
                .criteria();
        String bookmarkId = proxy.findIdByCriteria(criteria);

        String result;
        // si on retrouve l'alias prive on l'utilise,
        // sinon on espere qu'il existe un alias public portant ce nom
        if (bookmarkId != null) {
            result = BowConfig.getAliasUrl() + bookmarkId + ".action";
            if (log.isDebugEnabled()) {
                log.debug("Private alias found, redirect to: " + result);
            }
        } else {
            result = BowConfig.getAliasUrl() + privateAlias + ".action";
            if (log.isDebugEnabled()) {
                log.debug("Private alias not found, redirect to: " + result);
            }
        }
        redirectTo = result;
        return SUCCESS;
    }

    @Override
    protected String executeNotSupportedPrefixAction(String query) {
        // prefix inconnu, on va sur la home
        redirectTo = BowUtils.redirectTo(null, null);
        return SUCCESS;
    }

}
