/*
 * #%L
 * bow
 * 
 * $Id: ForgotPasswordAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/login/ForgotPasswordAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.login;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.chorem.bow.BowMail;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;

import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

/**
 * Genere un nouveau mot de passe pour l'utilisateur et lui envoie par mail
 * TODO poussin 20110211 il faudrait ajouter une securite pour eviter que
 * quelqu'un s'amuse a demander la modification de password de quelqu'un d'autre
 * toutes les 2s
 * - soit en ne permettant l'envoi qu'une fois par jour
 * - soit ????
 *
 * @author poussin
 */
public class ForgotPasswordAction extends BowBaseAction {
    private static final long serialVersionUID = -8207951465957204954L;

    protected String email;

    /** @return the email */
    public String getEmail() {
        return email;
    }

    /** @param email the email to set */
    public void setEmail(String email) {
        this.email = email;
    }

    /** Generates a new password and sends it to the user */
    @Override
    public String execute() {
        String result = INPUT;

        try {
            if (StringUtils.isNotBlank(email)) {
                email = email.trim();
                WikittyProxy proxy = getBowProxy();
                Criteria criteria = Search.query()
                        .eq(BowUser.FQ_FIELD_WIKITTYUSER_LOGIN, email).criteria();
                BowUser user = proxy.findByCriteria(BowUser.class, criteria);

                if (user != null) { //If the email address exists
                    String password;
                    String md5;

                    password = RandomStringUtils.randomAlphanumeric(20);
                    md5 = StringUtil.encodeMD5(password);
                    try {
                        String mailContent;

                        mailContent = _("bow.register.mailHi") +
                                      ",\n\n" + _("bow.register.mailPwd") + ": " +
                                      password + "\n\n" + _("bow.register.mailEmail") +
                                      ": " + email + "\n\n";
                        BowMail.sendMail(email,
                                         _("bow.register.mailSubject"),
                                         mailContent);

                        //The password is changed only if the mail has been sent
                        user.setPassword(md5);
                        proxy.store(user);
                    } catch (AddressException eee) {
                        //If the email address is invalid
                        addActionError(_("bow.mail.badFormat"));
                        log.error(String.format("Can't send message email to '%s'",
                                                email), eee);
                    } catch (MessagingException eee) {
                        addActionError("bow.mail.sendError");
                        log.error(String.format("Can't send message email to '%s'",
                                                email), eee);
                    }
                    result = SUCCESS;
                } else { //If the email is not associated with an account
                    addFieldError("email",
                                  _("bow.forgotPassword.emailDoesntExist"));
                }
            }
        } catch (Exception eee) {
            addActionError(_("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        return result;
    }
}