/*
 * #%L
 * bow
 * 
 * $Id: RemoveAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/bookmark/RemoveAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.bookmark;

import org.apache.commons.lang.StringUtils;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Supprime un bookmark
 *
 * @author poussin
 */
public class RemoveAction extends BowBaseAction {

    private static final long serialVersionUID = 820566716695285561L;

    protected String bookmarkId;

    protected String redirectTo;

    /** @return the bookmarkId */
    public String getBookmarkId() {
        return bookmarkId;
    }

    /** @param bookmarkId the bookmarkId to set */
    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    /** @return the redirectTo */
    public String getRedirectTo() {
        return redirectTo;
    }

    /** Removes a bookmark */
    @Override
    public String execute() {
        if (StringUtils.isNotEmpty(bookmarkId)) {
            try {
                WikittyProxy proxy = getBowProxy();
                proxy.delete(bookmarkId);
                addActionMessage(_("bow.bookmark.remove.successful"));
            } catch (Exception eee) {
                addActionError(_("bow.error.internal"));
                log.error("Can't do action", eee);
            }
        }
        redirectTo = BowUtils.redirectTo(tagLine, fullTextLine);
        return SUCCESS;
    }
}