/*
 * #%L
 * BOW UI
 * 
 * $Id: EditAction.java 324 2011-08-29 12:21:36Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-1.1/bow-ui/src/main/java/org/chorem/bow/action/bookmark/EditAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action.bookmark;

import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowBookmarkImpl;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;

/**
 * Load a bookmark to display it on modification page
 *
 * @author sletellier
 */
public class EditAction extends BowBaseAction {
    private static final long serialVersionUID = 1L;

    protected String id;

    protected BowBookmark bookmark;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BowBookmark getBookmark() {
        if (bookmark == null) {
            bookmark = new BowBookmarkImpl();
        }
        return bookmark;
    }

    @Override
    public String execute() throws Exception {
        if (id == null) {
            return SUCCESS;
        }
        try {
            WikittyProxy proxy = getBowProxy();
            Criteria criteria = Search.query()
                    .eq(Element.ELT_ID, id).criteria();
            bookmark = proxy.findByCriteria(BowBookmark.class, criteria);
        } catch (Exception eee) {
            addActionError(_("bow.error.internal"));
            log.error(eee.getMessage(), eee);
        }
        return SUCCESS;
    }
}
